/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.wsconsent.builders;

import java.util.List;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;

import be.ehealth.businessconnector.wsconsent.builders.impl.HcPartyInfoBuilderImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * HcPartyInfoBuilderImplTest test class.
 * 
 * @author EHP
 * 
 * 
 * 
 */
@Ignore("HcPartyInfoBuilder not used anymore , config properties removed")
@Deprecated
public class HcPartyInfoBuilderImplTest {

    private static Configuration config;

    @BeforeClass
    public static void init() throws Exception {
        // only integration tests need to run for all professionTypes
        Assume.assumeTrue("persphysician".equals(TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.wsconsent.test.properties").getProperty("session.professionType")));
        SessionInitializer.init("/be.ehealth.businessconnector.wsconsent.test.properties", false);
        config = ConfigFactory.getConfigValidator().getCurrentConfig();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    private HcPartyInfoBuilder builder = new HcPartyInfoBuilderImpl();

    @Test
    public void testCreateProfessionalParty() throws Exception {
        List<HcpartyType> actual = builder.getHcpPartiesForAuthor();
        HcpartyType careProviderParty = new HcpartyType();

        IDHCPARTY inss = new IDHCPARTY();
        inss.setS(IDHCPARTYschemes.INSS);
        inss.setValue(SessionUtil.getNiss());
        inss.setSV("1.0");

        IDHCPARTY nihii = new IDHCPARTY();
        nihii.setS(IDHCPARTYschemes.ID_HCPARTY);
        nihii.setSV("1.0");
        nihii.setValue(SessionUtil.getNihii11());

        CDHCPARTY cd = new CDHCPARTY();
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setSV("1.1");
        cd.setValue(config.getProperty("wsconsent.careprovider.quality"));

        careProviderParty.getIds().add(inss);
        careProviderParty.getIds().add(nihii);
        careProviderParty.getCds().add(cd);

        ReflectionAssert.assertLenientEquals(careProviderParty, actual.get(1));
    }

    @Test
    public void testcreateSoftwareIdentifierTest() throws Exception {
        List<HcpartyType> actual = builder.getHcpPartiesForAuthor();

        Assert.assertNotNull("Null object", actual);
        Assert.assertTrue("Wrong expected Size ", actual.size() > 0);
        HcpartyType softwareHcParty = new HcpartyType();

        IDHCPARTY idlocal = new IDHCPARTY();
        idlocal.setS(IDHCPARTYschemes.LOCAL);
        idlocal.setSL("application_ID");
        idlocal.setSV("1.0");
        idlocal.setValue(config.getProperty("software.id"));

        CDHCPARTY cd = new CDHCPARTY();
        cd.setS(CDHCPARTYschemes.CD_HCPARTY);
        cd.setSV("1.1");
        cd.setValue("application");

        softwareHcParty.getIds().add(idlocal);
        softwareHcParty.getCds().add(cd);

        softwareHcParty.setName(config.getProperty("package.name"));

        ReflectionAssert.assertLenientEquals(softwareHcParty, actual.get(0));
    }

}
