/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.handlers;

import java.io.InputStream;

import javax.xml.bind.JAXB;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.businessconnector.chapterIV.builders.BuilderFactory;
import be.ehealth.businessconnector.chapterIV.builders.ResponseBuilder;
import be.ehealth.businessconnector.chapterIV.validators.impl.Chapter4XmlValidatorImpl;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.validator.EhealthReplyValidator;
import be.ehealth.technicalconnector.validator.impl.EhealthReplyValidatorImpl;
import be.fgov.ehealth.chap4.core.v1.FaultType;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;


/**
 * tests the replyvalitor and the retrieval of the timestamp and response info from return object.
 * 
 * @author EHP
 * 
 */
public class ReplyValidatorAndReturnInfoRetrievalTest {

    private EhealthReplyValidator validator = new EhealthReplyValidatorImpl();

    private BuilderFactory factory;

    private ResponseBuilder responseBuilder;

    @Before
    public void setup() throws Exception {
        factory = new BuilderFactory(null, null, null, new Chapter4XmlValidatorImpl());
        responseBuilder = factory.getResponseBuilder();
    }

    @Test
    public void test() throws Exception {
        final InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream("/examples/response/responseWithValidationError.xml");
        ConsultChap4MedicalAdvisorAgreementResponse response = JAXB.unmarshal(xmlResourceInputStream, ConsultChap4MedicalAdvisorAgreementResponse.class);
        try {
            validator.validateReplyStatus(response);
            Assert.fail("should have thrown SoaErrorExeption");
        } catch (SoaErrorException e) {
            Assert.assertEquals("400", e.getErrorCode());
            Assert.assertNotNull(e.getResponseType());
            FaultType returnInfo = responseBuilder.retrieveReturnInfo(response);
            Assert.assertNotNull(returnInfo);
            Assert.assertNotNull(returnInfo.getMessage());
            Assert.assertEquals("5000000000789 : Authorization failure: Medical Advisor with ID: '10013368000' was not found in the system !", returnInfo.getMessage().getValue());
            Assert.assertEquals("IO-BE-500", returnInfo.getFaultSource());
        }
    }

}
