/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.insurability.service;

import be.ehealth.business.common.util.HandlerChainUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_INSURABILITY_V1 = "endpoint.insurability";
    private static final String PROP_VALIDATION_INCOMING_INSURABILITY = "validation.incoming.message.insurability.v1";
    private static final String INSURABILITY_PROT = "/XSD/ehealth-insurability/XSD/insurabilityservices_protocol-1_2.xsd";
    private static Configuration config = ConfigFactory.getConfigValidator();

    private ServiceFactory() {
    }

    public static GenericRequest getService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_INSURABILITY_V1, "$uddi{uddi:ehealth-fgov-be:business:insurability:v1}"));
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(HandlerChainUtil.buildChainWithValidator((String)PROP_VALIDATION_INCOMING_INSURABILITY, (String[])new String[]{INSURABILITY_PROT}));
        return genReq;
    }
}

