/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import java.util.Arrays;
import java.util.List;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.EndpointUpdateRule;

/**
 * @author EH053
 */
@RunWith(Parameterized.class)
public class EndpointDistributorTest {

    @Parameterized.Parameters(name = "{0}")
    public static List<Object[]> input() {
        return Arrays.asList(new Object[][]{{"serviceList V1", "/samples/servicelist/local/servicelist-local"}, {"serviceList V2", "/samples/servicelist/local/servicelistv2-local"}});
    }

    @Rule
    public EndpointUpdateRule rule = new EndpointUpdateRule();

    public EndpointDistributorTest(String name, String endpointLocation) {
        rule.setLocation(endpointLocation);
    }


    @Test
    public void oneServiceNoBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6666", Arrays.asList("http://localhost:6666", "http://localhost:6667"), null);
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertFalse(dist.mustPoll());
    }

    @Test
    public void oneServiceBCP() throws Exception {
        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6667", Arrays.asList("http://localhost:6666", "http://localhost:6667"), null);
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertTrue(dist.mustPoll());
    }

    @Test
    public void twoServiceNoBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6666", Arrays.asList("http://localhost:6666", "http://localhost:6667"), null);
        info.register("service:2", "http://localhost:7777", "http://localhost:7777", Arrays.asList("http://localhost:7777", "http://localhost:7777"), null);
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertFalse(dist.mustPoll());
    }

    @Test
    public void twoServiceBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6667", Arrays.asList("http://localhost:6666", "http://localhost:6667"), null);
        info.register("service:2", "http://localhost:7777", "http://localhost:7777", Arrays.asList("http://localhost:7777", "http://localhost:7777"), null);
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertTrue(dist.mustPoll());
    }
}
