/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.mappers;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Identification;
import be.ehealth.business.mycarenetdomaincommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.domain.Origin;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.chap4.core.v1.CommonInputType;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;


/**
 * Test of the common input mapper
 * 
 * @author EHP
 * 
 */
public class CommonInputMapperTest {

    private static final Logger LOG = LoggerFactory.getLogger(CommonInputMapperTest.class);

    @Test
    public void testCommonInputMapping() throws Exception {
        MarshallerHelper<CommonInputType, CommonInputType> helper = new MarshallerHelper<CommonInputType, CommonInputType>(CommonInputType.class, CommonInputType.class);
        CommonInputType commonInputExample = helper.toObjectNoRootElementRequired(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/commonInput-chap4.xml")));
        commonInputExample.getOrigin().getCareProvider().getPhysicalPerson().setCbe(null);

        Boolean istest = commonInputExample.getRequest().isIsTest();
        String ref = new String(commonInputExample.getInputReference());
        Nihii nihii = new Nihii(commonInputExample.getOrigin().getCareProvider().getNihii().getQuality(), commonInputExample.getOrigin().getCareProvider().getNihii().getValue().getValue());
        CareProvider careProvider = new CareProvider(nihii);
        Origin origin = new Origin(new McnPackageInfo(commonInputExample.getOrigin().getPackage().getLicense().getUsername(), commonInputExample.getOrigin().getPackage().getLicense().getPassword(), commonInputExample.getOrigin().getPackage().getName().getValue()), careProvider);
        CommonInput input = new CommonInput(istest, origin, ref);
        Identification physicalPerson = new Identification("Hannes De Clercq");
        physicalPerson.setSsin("82051234978");
        input.getOrigin().getCareProvider().setPhysicalPerson(physicalPerson);
        CommonInputType output = CommonInputMapper.mapCommonInputType(input);
        output.getOrigin().getCareProvider().getPhysicalPerson().setCbe(null);

        LOG.debug(helper.toStringNoRootElementRequired(output));

        XmlAsserter.assertSimilar(helper.toStringNoRootElementRequired(commonInputExample), helper.toStringNoRootElementRequired(output));
    }

}
