/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.sso;

import be.ehealth.technicalconnector.enumeration.SsoProfile;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;
import org.apache.commons.exec.OS;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

import java.awt.*;
import java.net.URI;


/**
 * IntegrationTest for the {@link SingleSignOnService}
 *
 * @author EHP
 */
public class SingleSignOnServiceTest {

    private static String relayState = "https://wwwacc.ehealth.fgov.be/nl/beroepsbeoefenaars-in-de-gezondheidszorg";

    private SingleSignOnService sso;

    private TestBrowser browser;

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession()
                                                .build();

    public static class TestBrowser implements BrowserHandler {
        private WebDriver driver;

        public TestBrowser() {
            if (!GraphicsEnvironment.isHeadless()) {
                System.setProperty("webdriver.chrome.driver", getDriverName());
                this.driver = new ChromeDriver();
            }
        }

        @Override
        public void browse(URI uri) {
            Assert.assertNotNull(uri);
            if (driver != null) {
                driver.get(uri.toString());
            }
        }

        public void close() {
            if (driver != null) {
                driver.close();
                driver.quit();
            }
        }

        public String getCurrentUrl() {
            return driver == null? StringUtils.EMPTY : driver.getCurrentUrl();
        }

        private String getDriverName() {
            String OS = System.getProperty("os.name").toLowerCase();
            return "target/webdrivers/chrome.driver" + (OS.contains("win")? ".exe" : "");
        }
    }

    @Before
    public void init() throws Exception {
        sso = ServiceFactory.getSingleSignOnService();
        browser = new TestBrowser();
        sso.setHandler(browser);
    }

    @After
    public void tearDown() {
        browser.close();
    }

    @Test
    public void withSAML2Artifact() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT, relayState);
        verifyCurrentUrl();
    }

    @Test
    public void withSAML2ArtifactWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT);
        verifyCurrentUrl();
    }

    @Test
    public void withSAML2POST() throws Exception {
        sso.signin(SsoProfile.SAML2_POST, relayState);
        verifyCurrentUrl();
    }

    @Test
    public void withSAML2POSTWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_POST);
        verifyCurrentUrl();
    }

    private void verifyCurrentUrl() {
        String currentUrl = browser.getCurrentUrl();
        if (!StringUtils.isEmpty(currentUrl)) {
            Assert.assertTrue(currentUrl.contains("wwwacc.ehealth.fgov.be"));
        }
    }

}
