/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mediprimav2.validator;

import static org.junit.Assert.assertTrue;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.mediprima.protocol.v2.ConsultCarmedInterventionRequest;
import be.fgov.ehealth.mediprima.protocol.v2.ConsultCarmedInterventionResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.RestoreSystemProperties;


/**
 * tests the class XmlValidator.
 *
 * @author EHP
 *
 * @since
 *
 */
public class XmlValidatorTest {

    @ClassRule
    public static RestoreSystemProperties restoreSystemPropertiesRule = new RestoreSystemProperties();

    /**
     * Test method for {@link be.ehealth.businessconnector.mediprimav2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateConsultCarmedInterventionRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/examples/mediprimav2/consultation/request/consultCarmedInterventionRequest.xml");
        MarshallerHelper<ConsultCarmedInterventionRequest, ConsultCarmedInterventionRequest> helper = new MarshallerHelper<ConsultCarmedInterventionRequest, ConsultCarmedInterventionRequest>(ConsultCarmedInterventionRequest.class, ConsultCarmedInterventionRequest.class);

        ConsultCarmedInterventionRequest xmlObject = helper.toObject(new FileInputStream(path));
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.mediprimav2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateConsultCarmedInterventionResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/examples/mediprimav2/consultation/expected/orgpharmacy/consultCarmedInterventionResponse.xml");
        MarshallerHelper<ConsultCarmedInterventionResponse, ConsultCarmedInterventionResponse> helper = new MarshallerHelper<ConsultCarmedInterventionResponse, ConsultCarmedInterventionResponse>(ConsultCarmedInterventionResponse.class, ConsultCarmedInterventionResponse.class);
        ConsultCarmedInterventionResponse xmlObject = helper.toObject(new FileInputStream(path));
        XmlValidator.validateXml(xmlObject);
    }

    @Test
    public void testConstructorIsPrivate() throws Exception {
        Constructor<XmlValidator> constructor = XmlValidator.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
            UnsupportedOperationException usoe = (UnsupportedOperationException) e.getTargetException();
            Assert.assertEquals("class may not be initialized, only static methods should be used", usoe.getMessage());
        }
    }
}
