/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dmg.session;

import java.util.List;

import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.kmehrcommons.HcPartyUtil;
import be.ehealth.businessconnector.dmg.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.dmg.domain.DMGReferences;
import be.ehealth.businessconnector.dmg.util.DmgConstants;
import be.ehealth.businessconnector.dmg.util.DmgTestUtils;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.NotifyGlobalMedicalFileRequest;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.NotifyGlobalMedicalFileResponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * @author EH076
 *
 */
public class Ehcon1109GmdCreationByInternIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("nicolas").build();

    @Test
    @Ignore("backend configuration for this case is missing , must be moved to unmaintained testcases")
    public void testCreationOfDmgByInternForDoctor() throws Exception {
        Patient pI = DmgTestUtils.createPatient("Madeleine", "De Maret", 300, 59120346292L);
        Kmehrmessage createDmgKmehrMessage = DmgTestUtils.getFilledSendTransactionRequestFromXmlFile();
        DateTime encounterDate = new DateTime();
        String nomenclature = "101076";

        // author and sender : doctor doing internship
        AuthorType author = HcPartyUtil.createAuthor(DmgConstants.PROJECT_IDENTIFIER);
        List<HcpartyType> senderHcParties = author.getHcparties();

        // dmg target = other doctor
        HcpartyType dmgTarget = HcPartyUtil.createProfessionalParty("82051234978", "18334780004", "persphysician");
        dmgTarget.setFirstname("Hannes");
        dmgTarget.setFamilyname("De Clercq");


        DmgTestUtils.replacePatientInFirstFolder(pI, "female", createDmgKmehrMessage);
        DmgTestUtils.replaceAuthorInFirstFolder(createDmgKmehrMessage, author);
        DmgTestUtils.replaceSenderInRequest(createDmgKmehrMessage, senderHcParties);
        DmgTestUtils.replaceDmgTargetInRequest(createDmgKmehrMessage, dmgTarget);
        DmgTestUtils.replaceEncounterDateInRequest(encounterDate, createDmgKmehrMessage);
        DmgTestUtils.replaceNomenclatureCodeInRequest(nomenclature, createDmgKmehrMessage);


        NotifyGlobalMedicalFileRequest request = RequestObjectBuilderFactory.getRequestObjectBuilder().buildSendNotifyRequest(false, new DMGReferences(true), pI, encounterDate, createDmgKmehrMessage);
        NotifyGlobalMedicalFileResponse response = DmgSessionServiceFactory.getDmgService().notifyGlobalMedicalFile(request);
        DmgTestUtils.validateSendResponseType(response);
    }

}
