/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.utils;


import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;


/**
 * Utility method to work with Logging
 *
 * @author EHP
 */
public class LoggingUtils {


    private static final Logger LOG = LoggerFactory.getLogger(LoggingUtils.class);

    private static boolean loaded = false;

    private static Object mutex = new Object();

    /**
     * Method to obtain a {@link TestAppender} that can be used to assert logging.
     *
     * @return
     */
    public static TestAppender getTestAppender() {
        TestAppender appender = new TestAppender();
        registerAppender(appender);
        return appender;
    }

    /**
     * Method to bootstrap the default logging as soon as possible
     */
    public static void bootstrap() {
        if (!loaded) {
            synchronized (mutex) {
                loaded = true;
                ConsoleAppender console = new ConsoleAppender();
                String PATTERN = "%d{dd-MM-yyyy | HH:mm:ss} | %-5p | %c{1}:%L | %m%n";
                console.setLayout(new PatternLayout(PATTERN));
                console.setThreshold(Level.TRACE);
                console.activateOptions();
                org.apache.log4j.Logger.getRootLogger()
                                       .addAppender(console);
            }
        }

    }

    /**
     * Method to register an {@link Appender}
     *
     * @param appender
     */
    public static void registerAppender(Appender appender) {
        org.apache.log4j.Logger.getRootLogger()
                               .addAppender(appender);
    }


}