package be.ehealth.technicalconnector.ws.domain;

import static be.ehealth.technicalconnector.ws.domain.HandlersLoader.addingDefaultHandlers;

import javax.xml.ws.handler.Handler;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.handler.HarFileHandler;
import be.ehealth.technicalconnector.handler.UserAgentHandler;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

/**
 * Created by EH053 on 03/10/2016.
 */
public class HandlersLoaderTest {

    @BeforeClass
    public static void init() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void containsRequired() throws Exception {
        Handler<?>[] input = new Handler<?>[]{new UserAgentHandler()};
        Handler<?>[] result = addingDefaultHandlers(input);
        Assert.assertEquals(5, result.length);
    }

    @Test
    public void dontContainsRequired() throws Exception {
        Handler<?>[] input = new Handler<?>[]{new HarFileHandler()};
        Handler<?>[] result = addingDefaultHandlers(input);
        Assert.assertEquals(6, result.length);
    }

}