package be.ehealth.businessconnector.vsbnet.async.session;

import be.cin.nip.async.generic.ConfirmResponse;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedPostResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityRequest;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.*;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.util.List;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNetPostGenericAsyncIntegrationTest {
    
    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();

    private static final String REQUEST_FOLDER = "/examples/vsbnet/async/request/";

    @Test
    public void _010_createApplication_TC_APP1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP1.xml");
    }

    @Test
    public void _020_createApplication_TC_APP2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP2.xml");
    }

    @Test
    public void _030_createApplication_TC_APP3() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP3.xml");
    }

    @Test
    public void _040_createApplication_TC_APP4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP4.xml");
    }

    @Test
    public void _050_createApplication_TC_APP5() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP5.xml");
    }

    @Test
    public void _060_createApplication_TC_APP6() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplication(REQUEST_FOLDER + "EMOHMDF101CreateApplicationRequest_TC_APP6.xml");
    }

    @Test
    public void _070_consultApplication_TC_CAPP1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultApplication(REQUEST_FOLDER + "EMOHMDF103ConsultApplicationRequest_TC_CAPP1.xml");
    }

    @Test
    public void _080_consultApplication_TC_CAPP2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultApplication(REQUEST_FOLDER + "EMOHMDF103ConsultApplicationRequest_TC_CAPP2.xml");
    }

    @Test
    public void _120_reportDelivery_TC_DEL1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL1.xml");
    }

    @Test
    public void _140_reportDelivery_TC_DEL2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL2.xml");
    }

    @Test
    public void _170_reportDelivery_TC_DEL3() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL3.xml");
    }

    @Test
    public void _180_reportDelivery_TC_DEL4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ReportDelivery(REQUEST_FOLDER + "EMOHMDF105ReportDeliveryRequest_TC_DEL4.xml");
    }

    @Test
    public void _200_consultSupportAndRepair_TC_CSUP1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepair(REQUEST_FOLDER + "EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP1.xml");
    }

    @Test
    public void _210_consultSupportAndRepair_TC_CSUP2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepair(REQUEST_FOLDER + "EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP2.xml");
    }

    @Test
    public void _211_consultSupportAndRepairList_1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_1.xml");
    }
    @Test
    public void _211_consultSupportAndRepairList_2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_2.xml");
    }
    @Test
    public void _211_consultSupportAndRepairList_3() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_3.xml");
    }
    @Test
    public void _211_consultSupportAndRepairList_4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(REQUEST_FOLDER + "EMOHMDF112ConsultSupportAndRepairRequestList_4.xml");
    }

    @Test
    public void _220_createFictionalApplicationRequest_TC_FAPP1() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP1.xml");
    }
    
    @Test
    public void _230_createFictionalApplicationRequest_TC_FAPP2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP2.xml");
    }

    @Test
    public void _240_createFictionalApplicationRequest_TC_FAPP3() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP3.xml");
    }

    @Test
    public void _250_createFictionalApplicationRequest_TC_FAPP4() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateFictionalApplication(REQUEST_FOLDER + "EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP4.xml");
    }
    
    @Test
    public void _270_postInvoiceList_TC01() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_RefusedInvoice("920000_TC01.txt");
    }

    @Test
    public void _280_postInvoiceList_TC02() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_AcceptedInvoice("920000_TC02.txt");
    }

    @Test
    public void _290_postInvoiceList_TC03() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_RefusedInvoice("920000_TC03.txt");
    }

    @Test
    public void _300_postInvoiceList_TC04() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_AcceptedInvoice("920000_TC04.txt");
    }

    @Test
    public void _310_determineInsurability_TC01() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_DetermineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_1.xml");
    }

    @Test
    public void _330_determineInsurability_TC03() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_DetermineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_3.xml");
    }

    @Test
    public void _340_determineInsurability_TC04() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_DetermineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_4.xml");
    }


}
