package be.ehealth.businessconnector.vsbnet.async.session;

import be.cin.nip.async.generic.GetResponse;
import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.PostResponse;
import be.cin.nip.async.generic.TAckResponse;
import be.cin.types.v1.Blob;
import be.ehealth.businessconnector.genericasync.helper.DefaultCommonAsyncService;
import be.ehealth.businessconnector.genericasync.helper.GetAndConfirmTestHelper;
import be.ehealth.businessconnector.genericasync.helper.PostTestHelper;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;

import java.util.Arrays;


/**
 * Example of usage for services not officially supported by the connector.
 * Here VL_INDREP VL_INDREP_CREATE_REQ and VL_INDREP_CREATE_RESP. In the example the projectName parameter is "vsb.indrep". 
 * 
 * @author EHP
 */
public class VsbNetGenericUsage {
    
    
    private Blob blobAgainstWhichXadesTManifestMustbeValidated;
    private String tackReferenceForWhichXadesTManifestMustbeValidated;

    public void postCreateIndicationReportExample() throws Exception {
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.istest", "true");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.vsbnet.indrep.request.xadestype", "xades");
        ConfigFactory.getConfigValidator().setProperty("endpoint.genericasync.vsbnet.indrep.v1", "https://pilot.myvsbnet.be:9443/vsb/bed/GenAsync/VL_INDREP");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.encodingtype", "none");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.contenttype", "text/xml");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.contentencryption", "encryptedForKnownRecipient");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.username", "your licence username");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.password", "your licence password");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.name", "your package name");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiertype", "CBE");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiervalue", "The vsb identifier value");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.application", "The vsb application id");
        
        PostTestHelper testHelper = PostTestHelper.Builder()
                .projectName("vsbnet.indrep")
                .platformName("vsbnet")
                .withXades(true).isTest(true)
                .isEncrypted(true)
                .build();
        byte[] request = ConnectorIOUtils.getResourceAsByteArray("your AVRDF501CreateIndicationReportRequest xml file");

        Post post = testHelper.buildPostRequest(request,
                "VL_INDREP_CREATE_REQ");
        PostResponse postResponse = testHelper.post("vsbnet.indrep", post);
        testHelper.validateResponse(postResponse);
        
        blobAgainstWhichXadesTManifestMustbeValidated = post.getDetail();
        tackReferenceForWhichXadesTManifestMustbeValidated = postResponse.getReturn().getReference();
    }

    public void getCreateIndicationReportExample() throws Exception {
        ConfigFactory.getConfigValidator().setProperty("endpoint.genericasync.vsbnet.indrep.v1", "https://pilot.myvsbnet.be:9443/vsb/bed/GenAsync/VL_INDREP");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.username", "your licence username");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.password", "your licence password");
        ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.name", "your package name");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiertype", "CBE");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiervalue", "The vsb identifier value");
        ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.application", "The vsb application id");
        
        GetAndConfirmTestHelper testHelper = GetAndConfirmTestHelper.Builder()
                .projectName("vsbnet.indrep")
                .messageNames(Arrays.asList("VL_INDREP_CREATE_RESP"))
                .maxMessages(1)
                .outputFileExtension(".txt")
                .outputDir("indrep")
                .replyToEtk(true)
                .build();
        GetResponse getResponse = testHelper.performGetAndConfirm(false);
        TAckResponse tAckResponse = getResponse.getReturn().getTAckResponses().get(0);
        if (tAckResponse.getTAck().getReference().equals(tackReferenceForWhichXadesTManifestMustbeValidated)) {
            new DefaultCommonAsyncService("vsbnet.indrep").validateXadesTWithManifest(tAckResponse,
                    blobAgainstWhichXadesTManifestMustbeValidated, tAckResponse.getXadesT().getValue());
        }    
    }

   
}
