/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mycarenet.memberdata.builders;

import be.ehealth.businessconnector.mycarenet.memberdata.domain.MemberDataBuilderResponse;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationResponse;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.AbstractSignatureTest;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

import java.io.InputStream;

/**
 * @author EHP
 */
public class ResponseObjectBuilderImplTest {

    @Test
    public void signaturesVerificationTest() throws Exception {
        ConfigFactory.getConfigValidator().setProperty("crypto.certificatechecker.classname", AbstractSignatureTest.CertificateCheckerStub.class.getName());

        InputStream is = ConnectorIOUtils.getResourceAsStream("/scenarios/response/SignaturesVerificationTest.xml");
        MemberDataConsultationResponse memberDataResponse = ConnectorXmlUtils.toObject(is, MemberDataConsultationResponse.class);
        IOUtils.closeQuietly(is);

        // Set Response to contain 9 assertion elements. Two of them are signed.
        memberDataResponse.getReturn().getDetail().setValue(("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><ns4:Response xmlns:ns4=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:ns2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:ns3=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns5=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ns6=\"urn:be:cin:types:v1\" xmlns:ns7=\"urn:be:cin:nippin:memberData:support:v2\" xmlns:ns8=\"urn:be:cin:nippin:memberdata:saml:extension\" ID=\"_1470ad65-6680-429a-b1cf-6329f7091bb4\" InResponseTo=\"_94-PHA-CMCB\" IssueInstant=\"2019-07-11T08:02:02\" Version=\"2.0\"><ns2:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:entity\">urn:be:cin:io:200</ns2:Issuer><ns4:Status><ns4:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></ns4:Status><ns2:Assertion ID=\"_0dc32bda-4fc0-45b5-bcd0-7eccfc8d3fc9\" IssueInstant=\"2019-07-11T08:02:02\" Version=\"2.0\"><ns2:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:entity\">urn:be:cin:io:600</ns2:Issuer><ns2:Subject><ns2:NameID Format=\"urn:be:cin:nippin:member:ssin@mut\">45011112215@603</ns2:NameID><ns2:SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><ns2:SubjectConfirmationData NotBefore=\"2017-12-16T00:00:00\" NotOnOrAfter=\"2018-01-16T00:00:00\"/></ns2:SubjectConfirmation></ns2:Subject><ns2:Advice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns8:AdviceType\"><ns8:AssertionType>urn:be:cin:nippin:insurability:patientData</ns8:AssertionType><ns8:Facet id=\"urn:be:cin:nippin:insurability\"><Dimension id=\"requestType\">invoicing</Dimension><Dimension id=\"contactType\">other</Dimension></ns8:Facet></ns2:Advice><ns2:AttributeStatement><ns2:Attribute Name=\"urn:be:fgov:person:ssin\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">45011112215</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:name\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">VANDENABEELE</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:firstName\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">NADINE</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:birthDate\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:date\">1945-01-11</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:gender\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">female</ns2:AttributeValue></ns2:Attribute></ns2:AttributeStatement></ns2:Assertion><ns2:Assertion ID=\"_4f6284e0-b2c3-4649-bcad-ea372e7f8609\" IssueInstant=\"2019-07-11T08:02:02\" Version=\"2.0\"><ns2:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:entity\">urn:be:cin:io:600</ns2:Issuer><ds:Signature xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859\"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/><ds:SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/><ds:Reference Id=\"xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859-ref0\" URI=\"#_4f6284e0-b2c3-4649-bcad-ea372e7f8609\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ds:DigestValue>rMS12KEJ7ja1JdkpzehqLuy9raW70VjaeSsadOQbf0U=</ds:DigestValue></ds:Reference><ds:Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859-signedprops\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ds:DigestValue>FjjY9NI9DYh4QFo4dQEbkKW/R5PAVBIJIwu0fh09G9g=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue Id=\"xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859-sigvalue\">lOwwhjA+IAclJ25lGifSYUjaX03oeGUQroOSHyVACa4NpNL66cgM+cRgSq0dOCgiyf2W/qIRG255lknORia68m83IeCOKk4vyWeqoQAcF3lgHokjdTA7NQzh8hbf1s/crQB3WZadMq+WhNxeOA+C5Eqq6l2z6wmSTtqYCaXI1RimZX8N3JtzrITwf/JCkJp5BgV8MoZ/BvoFLfHu22MjTKshhPhDY076i1DbNWM2JRfQreEOp939hCi8o1bzTaBMc8LSgnUMBr0289c5pwhdTg0/aPmp9d0o4EvLfN3lhh3a0tXNaovBH+8TtbPlCpJj1of19K2/EmvShXNPOBPjPQ==</ds:SignatureValue><ds:KeyInfo><ds:X509Data><ds:X509Certificate>MIIFezCCA2OgAwIBAgIUKVlIMaZSOdO9+lyGmZgI+kO2NOowDQYJKoZIhvcNAQELBQAwTjELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJDAiBgNVBAMTG1F1b1ZhZGlzIE5vIFJlbGlhbmNlIElDQSBHMzAeFw0xOTAyMjcxMzIxNTdaFw0xOTExMjYxODMxMDNaMIHsMQswCQYDVQQGEwJCRTEbMBkGA1UECgwSRmVkZXJhbCBHb3Zlcm5tZW50MRUwEwYDVQQLDAxNT0RDSEFQSVZBQ0MxFzAVBgNVBAsMDkNCRT0wMjA2NzMyNDM3MUYwRAYDVQQLDD1DIEEgQSBNIEkgIC0gQ0FJU1NFIEFVWElMSUFJUkUgRCBBU1NVUkFOQ0UgTUFMQURJRSBJTlZBTElESVRFMSEwHwYDVQQLDBhlSGVhbHRoLXBsYXRmb3JtIEJlbGdpdW0xJTAjBgNVBAMMHENCRT0wMjA2NzMyNDM3LCBNT0RDSEFQSVZBQ0MwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDiakySbmcMuIeys+nwSZeJ2jp+SejBslydRlBnk2o6AFplP4eyR9e2AGSfl51uIzTiKH2XPwOGoNvlnSWKnxoF17GZZK0VsXRc+291+bWDhkAihjLkk1FO3QLcDlyFLDvIm85GaBx5V9z+x+wWEIUl08J3bUDc6YqUuLfbXOypBPmAF6iydhHBDHtU/RBA4CUOMljM5kEta4mqrxkVE9Szb3WP9JvCcxdYMKoZQch73n+dKbVg8YCcroB7PelrhqkOSMlBWfF0SdtmuD2Rgi15aFWcgJrX2CNBjOtVNTbAutihLR7UMuRa95w2N2ZRC5ixAXmWVmqegvxoxhjaSYIpAgMBAAGjgbEwga4wHwYDVR0jBBgwFoAUfLGnKDAXeXJ6aJ5qGQ/WbqE1yD4wPQYIKwYBBQUHAQEEMTAvMC0GCCsGAQUFBzABhiFodHRwOi8vb2NzcGRldi5xdW92YWRpc2dsb2JhbC5jb20wHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMB0GA1UdDgQWBBRHGYgIIIPKujI9nVyYvhCj3j6wqzAOBgNVHQ8BAf8EBAMCBeAwDQYJKoZIhvcNAQELBQADggIBAAfWpC+2qqiMiNaICpVZ4lFeZYrgvYxmv4y80Ty2cpsOtdmuMer0vgjpyay1Ptc7cH/It1p4OcfIBJpq1T0DFUNPz4tbYxUjwb+eJHfYkOZOgK2XUncxrgM+1tLHPYuxsixa7j8rrfwdrOAAvR3kwPRDtoV2F4JQu/wukTSMBVcGrUBl+KC/dDrHrUYS45MohEW2nGs3xmJMGpDjBQCGhJuQ8z6SNzo0Vi9nchNCptESqjBSqn/Qmmj+ZX40RWmUW+BnscPQHpzw6V7Me0SZ0QXbIvrAR4Lir49ydGqLCoMwkMgHEWTWMCDYlFLK2/dDdoTxyZq0SlQfdyhOhU247nDYVaZk6ogfr/tU0qlcnMhDiKHvddItc5WRU6aWjndfdV2pS390Es/hZ2png/CROp+ihVQOsOlI+BQJBffmvPAtYVI9kDRdHRkwW+eLEqITFhTUxf6aYte3PN99exEDwuUmEnaWBK1/cPKgm2IRUR5usbgGQ1qTqZ5s726Dn3dUUUMSWiqKWPJg8NCSbtuBQ8pZw+MT6A60xunme4SeeVtFoZMAT4OdPyGChn6AZaTXFg1Qd2cCNL0/pac+RuMlab1kbouMPjwsk/u62kUTbiR/f5ZFiKLMyt5NVIEWLhJACRgTiFn2vXrDm7G1eqC6C5lxNd05Ksam0nrxTvb/4v2F</ds:X509Certificate><ds:X509SubjectName>CN=CBE\\=0206732437\\, MODCHAPIVACC,OU=eHealth-platform Belgium,OU=C A A M I  - CAISSE AUXILIAIRE D ASSURANCE MALADIE INVALIDITE,OU=CBE\\=0206732437,OU=MODCHAPIVACC,O=Federal Government,C=BE</ds:X509SubjectName><ds:X509IssuerSerial><ds:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ds:X509IssuerName><ds:X509SerialNumber>236059676905948500332879769216449334108082287850</ds:X509SerialNumber></ds:X509IssuerSerial></ds:X509Data></ds:KeyInfo><ds:Object><xades:QualifyingProperties xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:xades141=\"http://uri.etsi.org/01903/v1.4.1#\" Target=\"#xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859\"><xades:SignedProperties Id=\"xmldsig-8af17564-8ee7-4e96-ae0a-ca8a87d36859-signedprops\"><xades:SignedSignatureProperties><xades:SigningTime>2019-07-11T10:02:02.048+02:00</xades:SigningTime><xades:SigningCertificate><xades:Cert><xades:CertDigest><ns3:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns3:DigestValue>s3MY1OLwWDJ6zWWf+5I3dDB6cAbxbj2M+YDShVSS/AQ=</ns3:DigestValue></xades:CertDigest><xades:IssuerSerial><ns3:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ns3:X509IssuerName><ns3:X509SerialNumber>236059676905948500332879769216449334108082287850</ns3:X509SerialNumber></xades:IssuerSerial></xades:Cert><xades:Cert><xades:CertDigest><ns3:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns3:DigestValue>KWB77dDBOelxJCY76yccMFx515HHc2A2LR4SfdT1AFQ=</ns3:DigestValue></xades:CertDigest><xades:IssuerSerial><ns3:X509IssuerName>CN=QuoVadis No Reliance Root CA G2,OU=Root Certification Authority,O=QuoVadis Limited,C=BM</ns3:X509IssuerName><ns3:X509SerialNumber>135325844327279628438963606464705833756599436917</ns3:X509SerialNumber></xades:IssuerSerial></xades:Cert></xades:SigningCertificate></xades:SignedSignatureProperties></xades:SignedProperties></xades:QualifyingProperties></ds:Object></ds:Signature><ns2:Subject><ns2:NameID Format=\"urn:be:cin:nippin:member:ssin@mut\">45011112215@603</ns2:NameID><ns2:SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><ns2:SubjectConfirmationData NotBefore=\"2017-12-16T00:00:00\" NotOnOrAfter=\"2018-01-16T00:00:00\"/></ns2:SubjectConfirmation></ns2:Subject><ns2:Conditions NotBefore=\"2019-07-11T00:00:00\" NotOnOrAfter=\"2019-08-11T00:00:00\"/><ns2:Advice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns8:AdviceType\"><ns8:AssertionType>urn:be:cin:nippin:insurability:period</ns8:AssertionType><ns8:Facet id=\"urn:be:cin:nippin:insurability\"><Dimension id=\"requestType\">invoicing</Dimension><Dimension id=\"contactType\">other</Dimension></ns8:Facet></ns2:Advice><ns2:AttributeStatement><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:registrationNumber\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">0603001191932</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:careReceiver:mutuality\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">603</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:cb1\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">130</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:cb2\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">130</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:paymentApproval\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">a770be52915204cc75a1f1b2b35358a5</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:communicationDate\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:date\">2019-07-11</ns2:AttributeValue></ns2:Attribute></ns2:AttributeStatement></ns2:Assertion><ns2:Assertion ID=\"_2568b4b8-ab83-49f2-b7b1-03d174f4cebd\" IssueInstant=\"2019-07-11T08:02:02\" Version=\"2.0\"><ns2:Issuer Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:entity\">urn:be:cin:io:200</ns2:Issuer><ds:Signature xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f\"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/><ds:SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/><ds:Reference Id=\"xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f-ref0\" URI=\"#_2568b4b8-ab83-49f2-b7b1-03d174f4cebd\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ds:DigestValue>20kNT/mpnI6MbLeh5TEb9PR9Cn3Oumne/VbB6U/Pw6A=</ds:DigestValue></ds:Reference><ds:Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f-signedprops\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ds:DigestValue>hAOHMd/fnYR1AY0Ka+nc8W82Abg8+ERI2qkYgtJ07ec=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue Id=\"xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f-sigvalue\">ACBxvp1kPeV3VUrVUrA+OG+k8JB4eXwtQ0/suUTlWCz961x8EusJsxNMdl+D529xU9G4yh1BxumlcgqQi7CMlhBCrD90QFVRF1eMXHR6DNju9UFfrGC8BgXqthAOUn26VW/cPDZusO7b9LOKzTTg0H3PyukH8qMrOrxI0ZEyyRGsWxjp64aCqMoTjgMEbgFEMPybyVY/m4c0QATiQw2DViqtyCpM1g9K8KYjaXpk7R0KfQgapgBb0ay3K/KNdyOl50TPlwukNprF/KRECRprrpZNz1SKg5CSvyR5RTtNKZj7kD3FxzbicuO8Pqacwci441ROCBcK4Lcmb8t8/h01QQ==</ds:SignatureValue><ds:KeyInfo><ds:X509Data><ds:X509Certificate>MIIFezCCA2OgAwIBAgIUKVlIMaZSOdO9+lyGmZgI+kO2NOowDQYJKoZIhvcNAQELBQAwTjELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJDAiBgNVBAMTG1F1b1ZhZGlzIE5vIFJlbGlhbmNlIElDQSBHMzAeFw0xOTAyMjcxMzIxNTdaFw0xOTExMjYxODMxMDNaMIHsMQswCQYDVQQGEwJCRTEbMBkGA1UECgwSRmVkZXJhbCBHb3Zlcm5tZW50MRUwEwYDVQQLDAxNT0RDSEFQSVZBQ0MxFzAVBgNVBAsMDkNCRT0wMjA2NzMyNDM3MUYwRAYDVQQLDD1DIEEgQSBNIEkgIC0gQ0FJU1NFIEFVWElMSUFJUkUgRCBBU1NVUkFOQ0UgTUFMQURJRSBJTlZBTElESVRFMSEwHwYDVQQLDBhlSGVhbHRoLXBsYXRmb3JtIEJlbGdpdW0xJTAjBgNVBAMMHENCRT0wMjA2NzMyNDM3LCBNT0RDSEFQSVZBQ0MwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDiakySbmcMuIeys+nwSZeJ2jp+SejBslydRlBnk2o6AFplP4eyR9e2AGSfl51uIzTiKH2XPwOGoNvlnSWKnxoF17GZZK0VsXRc+291+bWDhkAihjLkk1FO3QLcDlyFLDvIm85GaBx5V9z+x+wWEIUl08J3bUDc6YqUuLfbXOypBPmAF6iydhHBDHtU/RBA4CUOMljM5kEta4mqrxkVE9Szb3WP9JvCcxdYMKoZQch73n+dKbVg8YCcroB7PelrhqkOSMlBWfF0SdtmuD2Rgi15aFWcgJrX2CNBjOtVNTbAutihLR7UMuRa95w2N2ZRC5ixAXmWVmqegvxoxhjaSYIpAgMBAAGjgbEwga4wHwYDVR0jBBgwFoAUfLGnKDAXeXJ6aJ5qGQ/WbqE1yD4wPQYIKwYBBQUHAQEEMTAvMC0GCCsGAQUFBzABhiFodHRwOi8vb2NzcGRldi5xdW92YWRpc2dsb2JhbC5jb20wHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMB0GA1UdDgQWBBRHGYgIIIPKujI9nVyYvhCj3j6wqzAOBgNVHQ8BAf8EBAMCBeAwDQYJKoZIhvcNAQELBQADggIBAAfWpC+2qqiMiNaICpVZ4lFeZYrgvYxmv4y80Ty2cpsOtdmuMer0vgjpyay1Ptc7cH/It1p4OcfIBJpq1T0DFUNPz4tbYxUjwb+eJHfYkOZOgK2XUncxrgM+1tLHPYuxsixa7j8rrfwdrOAAvR3kwPRDtoV2F4JQu/wukTSMBVcGrUBl+KC/dDrHrUYS45MohEW2nGs3xmJMGpDjBQCGhJuQ8z6SNzo0Vi9nchNCptESqjBSqn/Qmmj+ZX40RWmUW+BnscPQHpzw6V7Me0SZ0QXbIvrAR4Lir49ydGqLCoMwkMgHEWTWMCDYlFLK2/dDdoTxyZq0SlQfdyhOhU247nDYVaZk6ogfr/tU0qlcnMhDiKHvddItc5WRU6aWjndfdV2pS390Es/hZ2png/CROp+ihVQOsOlI+BQJBffmvPAtYVI9kDRdHRkwW+eLEqITFhTUxf6aYte3PN99exEDwuUmEnaWBK1/cPKgm2IRUR5usbgGQ1qTqZ5s726Dn3dUUUMSWiqKWPJg8NCSbtuBQ8pZw+MT6A60xunme4SeeVtFoZMAT4OdPyGChn6AZaTXFg1Qd2cCNL0/pac+RuMlab1kbouMPjwsk/u62kUTbiR/f5ZFiKLMyt5NVIEWLhJACRgTiFn2vXrDm7G1eqC6C5lxNd05Ksam0nrxTvb/4v2F</ds:X509Certificate><ds:X509SubjectName>CN=CBE\\=0206732437\\, MODCHAPIVACC,OU=eHealth-platform Belgium,OU=C A A M I  - CAISSE AUXILIAIRE D ASSURANCE MALADIE INVALIDITE,OU=CBE\\=0206732437,OU=MODCHAPIVACC,O=Federal Government,C=BE</ds:X509SubjectName><ds:X509IssuerSerial><ds:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ds:X509IssuerName><ds:X509SerialNumber>236059676905948500332879769216449334108082287850</ds:X509SerialNumber></ds:X509IssuerSerial></ds:X509Data></ds:KeyInfo><ds:Object><xades:QualifyingProperties xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:xades141=\"http://uri.etsi.org/01903/v1.4.1#\" Target=\"#xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f\"><xades:SignedProperties Id=\"xmldsig-1617dd97-8c29-43ac-a97a-9bc13553cd6f-signedprops\"><xades:SignedSignatureProperties><xades:SigningTime>2019-07-11T10:02:02.125+02:00</xades:SigningTime><xades:SigningCertificate><xades:Cert><xades:CertDigest><ns3:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns3:DigestValue>s3MY1OLwWDJ6zWWf+5I3dDB6cAbxbj2M+YDShVSS/AQ=</ns3:DigestValue></xades:CertDigest><xades:IssuerSerial><ns3:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ns3:X509IssuerName><ns3:X509SerialNumber>236059676905948500332879769216449334108082287850</ns3:X509SerialNumber></xades:IssuerSerial></xades:Cert><xades:Cert><xades:CertDigest><ns3:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns3:DigestValue>KWB77dDBOelxJCY76yccMFx515HHc2A2LR4SfdT1AFQ=</ns3:DigestValue></xades:CertDigest><xades:IssuerSerial><ns3:X509IssuerName>CN=QuoVadis No Reliance Root CA G2,OU=Root Certification Authority,O=QuoVadis Limited,C=BM</ns3:X509IssuerName><ns3:X509SerialNumber>135325844327279628438963606464705833756599436917</ns3:X509SerialNumber></xades:IssuerSerial></xades:Cert></xades:SigningCertificate></xades:SignedSignatureProperties></xades:SignedProperties></xades:QualifyingProperties></ds:Object></ds:Signature><ns2:Subject><ns2:NameID Format=\"urn:be:cin:nippin:member:ssin@mut\">45011112215@603</ns2:NameID><ns2:SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><ns2:SubjectConfirmationData NotBefore=\"2017-12-16T00:00:00\" NotOnOrAfter=\"2018-01-16T00:00:00\"/></ns2:SubjectConfirmation></ns2:Subject><ns2:Advice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns8:AdviceType\"><ns8:AssertionType>urn:be:cin:nippin:unitIssuance</ns8:AssertionType><ns8:Facet id=\"urn:be:cin:nippin:insurability\"><Dimension id=\"requestType\">invoicing</Dimension><Dimension id=\"contactType\">other</Dimension></ns8:Facet></ns2:Advice><ns2:AttributeStatement><ns2:Attribute Name=\"urn:be:cin:nippin:retirement:nihii11\"><ns2:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"/></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:retirement:hospitalised\"><ns2:AttributeValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"/></ns2:Attribute></ns2:AttributeStatement></ns2:Assertion><ns2:Assertion ID=\"_0af969f1-0ce1-4b46-a4a6-cf17639fe308\" IssueInstant=\"2019-07-11T10:02:02\" Version=\"2.0\"><ns2:Issuer>urn:be:cin:io:600</ns2:Issuer><ns2:Subject><ns2:NameID Format=\"urn:be:cin:nippin:member:ssin@mut\">45011112215@603</ns2:NameID><ns2:SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><ns2:SubjectConfirmationData NotBefore=\"2017-12-16T00:00:00\" NotOnOrAfter=\"2018-01-16T00:00:00\"/></ns2:SubjectConfirmation></ns2:Subject><ns2:Advice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns8:AdviceType\"><ns8:AssertionType>urn:be:cin:nippin:technicalAssertion</ns8:AssertionType><ns8:Facet id=\"urn:be:cin:nippin:insurability\"><Dimension id=\"requestType\">invoicing</Dimension><Dimension id=\"contactType\">other</Dimension></ns8:Facet></ns2:Advice><ns2:AttributeStatement><ns2:Attribute Name=\"urn:be:cin:nippin:technicalAssertion:status\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">5VdtT9swEP4rkfcNiTgUBswiZaWEqRK0KGm1SQghN7m1llLbs52W/nuctGkTXsXWTkz70ubsu+fs5zmfk5PT+0nqTEFpJriP9lwPOcBjkTA+8tGgf7F7jBxtKE9oKjj4aA4anTZPuD4ikaEm044F4Jpw3fBRpjgRVDNr0gloYmISta4uScP1CNUalLFZ0Cpi30djYyTBeDabubN9V6gRbnieh70v2Dolmo0+rd0PXk8glTAiFuk64PML+HvYO8jx7UYr8IcL+CGQmHFi5tLiT/fW80e1ec6ktH8TmAxBnVNDic6kFMqQaWMdc/xyTFLE0ElK4N4A1wUzlnjL8fdW2O10vxVKqLnMSQvhV8YUJD76SVMNaKFAoJRQ+eMhuaBZato2vNnpXg/6d0EY9sITXJ9ae0YiU7H17e2eBbuHnlfxXE4VvlegNR1ZA9es3DgHQ1mqcTFXWUpeFyCdXB8fhaCl4Brclfou4zpTdMhSZuauBMVE4o6Ag6JpUWm2pHwUDdrtIIqQk4qYmqI0EX4/Op1PgJvtwRtm4XPxt5Ui48x0tM4oj+FvbCNOgfJMugnEQDUkdhA2nm+heZlqKVJL2vM73cLu6tliwROWe+ktJQKuWDx2befiFl1tnr1lTZcb2vLRKdNQYxQbZgYqvBUtppZnY10puvrthlQ1qs9FqkE3+HEdtPvB+V2r3w87Z4N+sICqOFWCytT46VA+crncenPHLqW8CEpqr5WQQhfFhnfIwoKknLVDrZL6m/3b3Cwpzu9VyNmvDt587ebCPb1NlkqR4bzTu10sdLWsGmVmDM5KRud1IIdphwvj0DQVM0gcxh0ztmP2+Bh7XT1iHz/P+P/EvpYQM2qXl/+2LcJIqPlG5HgW+Q/0wbWzUr27cdkj3t0txkJLZmjKdLHRbTWlx2le7IH/eGeKoiDsd3rdD3A2Dt6u4dLXeSTPB6vR2qvUlm/PWq6NvREswt4bvtLSvaAxmLfj8frbrvkA</ns2:AttributeValue></ns2:Attribute><ns2:Attribute Name=\"urn:be:cin:nippin:technicalAssertion:version\"><ns2:AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">FBIOSM-203</ns2:AttributeValue></ns2:Attribute></ns2:AttributeStatement></ns2:Assertion></ns4:Response>").getBytes("UTF-8"));


        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        MemberDataBuilderResponse builderResponse = responseBuilder.handleConsultationResponse(memberDataResponse);

        SignatureVerificationResult success = builderResponse.getSignatureVerificationResult().get("_4f6284e0-b2c3-4649-bcad-ea372e7f8609");
        SignatureVerificationResult failure = builderResponse.getSignatureVerificationResult().get("_2568b4b8-ab83-49f2-b7b1-03d174f4cebd");

        Assert.assertEquals(2, builderResponse.getSignatureVerificationResult().size());
        Assert.assertEquals("Unexpected error found in the verification results", 0, success.getErrors().size());
        Assert.assertEquals("Unexpected success found in the verification results", 1, failure.getErrors().size());
    }

}
