/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mediprima.session;

import be.ehealth.businessconnector.testcommons.utils.SessionTestUtils;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionManager;
import be.fgov.ehealth.mediprima.protocol.v1.ConsultCarmedInterventionRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.RestoreSystemProperties;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import static org.junit.Assert.assertTrue;


/**
 * 
 * @author EH071
 * 
 * @since
 * 
 */
public class MediprimaSessionServiceFactoryTest {


    private SessionManager noSessionManager;


    @ClassRule
    public static RuleChain chain = RuleChain.outerRule(new RestoreSystemProperties()).around(SessionRule.withInactiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build());

    @Before
    public void initialize() throws Exception {
        noSessionManager = EasyMock.createNiceMock(SessionManager.class);
    }


    /**
     * Test method for {@link MediprimaSessionServiceFactory#getConsultationMediprimaSession()}.
     */
    @Test
    public void testGetMediprimaSession() throws ConnectorException {
        try {
            Session.setSessionManager(SessionTestUtils.getDummySessionManager());
            MediprimaConsultationSessionService dicsSession = MediprimaSessionServiceFactory.getConsultationMediprimaSession();
            Assert.assertNotNull(dicsSession);
        } finally {
            Session.setSessionManager(null);
        }

    }

    /**
     * Test method for {@link MediprimaSessionServiceFactory#getConsultationMediprimaSession()}.
     */
    @Test
    public void testCallTarificationSessionWithoutSession() throws ConnectorException {
        try {
            Session.setSessionManager(noSessionManager);
            EasyMock.expect(noSessionManager.hasValidSession()).andReturn(false);
            EasyMock.replay(noSessionManager);
            MediprimaConsultationSessionService mediprimaSession = MediprimaSessionServiceFactory.getConsultationMediprimaSession();
            mediprimaSession.consultCarmedIntervention(new ConsultCarmedInterventionRequest());
            Assert.fail("should have thrown exception because there is no Session active");
        } catch (TechnicalConnectorException e) {
            Assert.assertEquals("No active session found", e.getMessage());
        }
    }


    @Test
    public void testConstructorIsPrivate() throws Exception {

        Constructor<MediprimaSessionServiceFactory> constructor = MediprimaSessionServiceFactory.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
        }
    }

}
