/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.validator;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.*;

import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.service.timestamp.TimestampUtil;
import be.ehealth.technicalconnector.validator.impl.TimeStampValidatorFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * tests the loading of the configs and creation of TimeStampValidator in {@link TimeStampValidatorFactory}.
 * 
 * @author EHP
 */
public class TimeStampValidatorFactoryTest {

    @Rule
    public SessionRule rule = SessionRule.withInactiveSession()
                                         .build();

    @After
    public void destroy() throws Exception {
        TimeStampValidatorFactory.reset();
    }

    @Test
    public void obtainInstance() throws Exception {
        TimeStampValidator validator = TimeStampValidatorFactory.getInstance();
        Assert.assertNotNull(validator);
    }

    @Test(expected = IllegalArgumentException.class)
    public void validateNullValue() throws Exception {
        TimeStampValidator validator = TimeStampValidatorFactory.getInstance();
        validator.validateTimeStampToken(null);
    }

    @Test
    public void validate() throws Exception {
        byte[] tsToken = base64Decode(getBytes(getResourceAsStream("/examples/tstoken.base64")), true);
        TimeStampValidator validator = TimeStampValidatorFactory.getInstance();
        TimeStampResponse resp = new TimeStampResponse(tsToken);
        validator.validateTimeStampToken(resp.getTimeStampToken());
    }

    @Test
    public void validateProductionToken() throws Exception {
        ConfigFactory.getConfigValidatorFor()
                     .setProperty("KEYSTORE_DIR", "/P12/prod/");
        byte[] tsToken = base64Decode(getBytes(getResourceAsStream("/examples/tstoken_prod.base64")), true);
        TimeStampValidator validator = TimeStampValidatorFactory.getInstance();
        TimeStampToken resp = TimestampUtil.getTimeStampToken(tsToken);
        validator.validateTimeStampToken(resp);

        ConfigFactory.getConfigValidatorFor()
                     .setProperty("KEYSTORE_DIR", "/P12/prod/");
    }
}
