/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;


/**
 * Basic test of the seriaalize of an object
 * 
 * @author EHP
 */
public class ChapterIVBuilderResponseTest {

    @Test
    public void testSerializeObject() {
        Map<String, Serializable> testMap = new HashMap<String, Serializable>();
        testMap.put("test", "test");
        ChapterIVBuilderResponse response = new ChapterIVBuilderResponse(testMap);
        byte[] serializedDocument = SerializationUtils.serialize(response);
        ChapterIVBuilderResponse deserializedDocument = (ChapterIVBuilderResponse) SerializationUtils.deserialize(serializedDocument);
        Assert.assertEquals(response, deserializedDocument);
    }
}
