/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.getBytes;
import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.getResourceAsStream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.XadesOption;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;

/**
 * tests the SignatureBuilder.
 * 
 * @author EHP
 */
public class XadesTSignatureTest extends AbstractSignatureTest {


    @BeforeClass
    public static void initBuilder() throws Exception {
        builder = SignatureBuilderFactory.getSignatureBuilder(AdvancedElectronicSignatureEnumeration.XAdES_T);
    }


    @AfterClass
    public static void teardown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void testBuildXadesT() throws Exception {
        verifyEnvironment();
        byte[] signature = generateXadesT();
        System.out.println(new String(signature));
        Assert.assertNotNull("Signature = null", signature);
        Assert.assertTrue("Empty signature", signature.length > 0);
    }

    private void verifyEnvironment() throws Exception {
        AssumeTools.isInternetConnectionEnabled();
        SessionInitializer.init(true);
        ConfigFactory.getConfigValidator().setProperty("crypto.certificatechecker.classname", CertificateCheckerStub.class.getName());

    }

    private byte[] generateXadesT() throws Exception {
        Map<String, Object> options = new HashMap<String, Object>();
        List<String> tranforms = new ArrayList<String>();
        tranforms.add("http://www.w3.org/2000/09/xmldsig#base64");
        options.put(XadesOption.TRANSFORMERLIST, tranforms);
        options.put(XadesOption.BASEURI, "_82403f5e-8f31-4b6f-a0ef-c76d60cc2f13");
        options.put(XadesOption.SIGNATURETIMESTAMP_TSA_URL, "https://services-acpt.ehealth.fgov.be/TimestampAuthority/v2");
        return builder.sign(credential, textToSign, options);
    }


    @Test
    public void testValidateXadesT() throws Exception {
        byte[] signature = getBytes(getResourceAsStream("/examples/xadest.sign"));
        byte[] signedByteArray = ConnectorIOUtils.getBytes(getResourceAsStream("/examples/xadest.with.referenced.request"));
        verifyXades(signature, signedByteArray, SignatureVerificationError.CERTIFICATE_EXPIRED);
    }


    @Test
    public void testValidGeneratedXadesT() throws Exception {
        verifyEnvironment();
        verifyXades(generateXadesT(), textToSign);
    }

    @Override
    String getVerificationTemplate() {
        return "/result/expected/xades.timestamp.xml";
    }

}
