package be.ehealth.businessconnector.vsbnet.async.session;

import be.cin.nip.async.generic.ConfirmResponse;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedPostResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityRequest;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF101CreateApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF101CreateApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF102CreateFictionalApplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF102CreateFictionalApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF103ConsultApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF103ConsultapplicationRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF104ConsultSupportAndRepairRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF104ConsultSupportAndRepairResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF105ReportDeliveryRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF105ReportDeliveryResponse;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.util.List;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNetPostGenericAsyncIntegrationTest {

    private static final int SECONDS_WAITING = 120;
    
    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();


    private static final String REQUEST_FOLDER = "/examples/vsbnet/async/request/";
    

    @Test
    public void _010_createApplication_TC_APP1() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP1.xml");
    }

    @Test
    public void _020_createApplication_TC_APP2() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP2.xml");
    }

    @Test
    public void _030_createApplication_TC_APP3() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP3.xml");
    }

    @Test
    public void _040_createApplication_TC_APP4() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP4.xml");
    }

    @Test
    public void _050_createApplication_TC_APP5() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP5.xml");
    }

    @Test
    public void _060_createApplication_TC_APP6() throws Exception {
        createApplication("EMOHMDF101CreateApplicationRequest_TC_APP6.xml");
    }

    private void createApplication(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .createApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                EMOHMDF101CreateApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    @Test
    public void _070_consultApplication_TC_CAPP1() throws Exception {
        consultApplication("EMOHMDF103ConsultApplicationRequest_TC_CAPP1.xml");
    }
    
    private void consultApplication(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                EMOHMDF103ConsultapplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    @Test
    public void _080_consultApplication_TC_CAPP2() throws Exception {
        consultApplication("EMOHMDF103ConsultApplicationRequest_TC_CAPP2.xml");
    }

    @Test
    public void _120_reportDelivery_TC_DEL1() throws Exception {
        reportDelivery("EMOHMDF105ReportDeliveryRequest_TC_DEL1.xml");
    }

    @Test
    public void _140_reportDelivery_TC_DEL2() throws Exception {
        reportDelivery("EMOHMDF105ReportDeliveryRequest_TC_DEL2.xml");
    }

    @Test
    public void _170_reportDelivery_TC_DEL3() throws Exception {
        reportDelivery("EMOHMDF105ReportDeliveryRequest_TC_DEL3.xml");
    }

    @Test
    public void _180_reportDelivery_TC_DEL4() throws Exception {
        reportDelivery("EMOHMDF105ReportDeliveryRequest_TC_DEL4.xml");
    }

    private void reportDelivery(String s) throws ConnectorException, InterruptedException {
        EMOHMDF105ReportDeliveryRequest b = ConnectorXmlUtils
                      .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),  EMOHMDF105ReportDeliveryRequest.class);
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .reportDelivery(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                EMOHMDF105ReportDeliveryRequest.class),  generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    @Test
    public void _200_consultSupportAndRepair_TC_CSUP1() throws Exception {
        consultSupportAndRepair("EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP1.xml");
    }

    private void consultSupportAndRepair(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .consultSupportAndRepair(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                EMOHMDF104ConsultSupportAndRepairRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
        VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }


    @Test
    public void _210_consultSupportAndRepair_TC_CSUP2() throws Exception {
        consultSupportAndRepair("EMOHMDF104ConsultSupportAndRepairRequest_TC_CSUP2.xml");
    }

    @Test
    public void _220_createFictionalApplicationRequest_TC_FAPP1() throws Exception {
        createFictionalApplication("EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP1.xml");
    }
    
    @Test
    public void _230_createFictionalApplicationRequest_TC_FAPP2() throws Exception {
        createFictionalApplication("EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP2.xml");
    }

    @Test
    public void _240_createFictionalApplicationRequest_TC_FAPP3() throws Exception {
        createFictionalApplication("EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP3.xml");
    }

    @Test
    public void _250_createFictionalApplicationRequest_TC_FAPP4() throws Exception {
        createFictionalApplication("EMOHMDF102CreateFictionalApplicationRequest_TC_FAPP4.xml");
    }

    private void createFictionalApplication(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .createFictionalApplication(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                EMOHMDF102CreateFictionalApplicationRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }
    
    @Test
    public void _270_postInvoiceList_TC01() throws Exception {
        postRefusedInvoice("920000_TC01.txt");
    }

    private void postRefusedInvoice(String s) throws ConnectorException,  InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
        validateXadesTOfTAckResponseWithManifest(processedPostResponse, response);
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    private void validateXadesTOfTAckResponseWithManifest(ProcessedPostResponse processedPostResponse, ProcessedGetResponse<byte[]> response) throws ConnectorException {
        SignatureVerificationResult signatureVerificationResult = VsbNetSessionServiceFactory.getVsbNetInvoiceService().validateXadesTWithManifest(response.getTAckResponses().get(0).getTAckResponse(), processedPostResponse.getPost().getDetail(), response.getTAckResponses().get(0).getTAckResponse().getXadesT().getValue());
        assertTrue(signatureVerificationResult.getErrors().isEmpty());
    }

    @Test
    public void _280_postInvoiceList_TC02() throws Exception {
        postAcceptedInvoice("920000_TC02.txt");
    }

    private void postAcceptedInvoice(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileAccepted(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    @Test
    public void _290_postInvoiceList_TC03() throws Exception {
        postRefusedInvoice("920000_TC03.txt");
    }

    @Test
    public void _300_postInvoiceList_TC04() throws Exception {
        postAcceptedInvoice("920000_TC04.txt");
    }

    @Test
    public void _310_determineInsurability_TC01() throws Exception {
        determineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_1.xml");
    }

    @Test
    public void _330_determineInsurability_TC03() throws Exception {
        determineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_3.xml");
    }

    @Test
    public void _340_determineInsurability_TC04() throws Exception {
        determineInsurability("WZCMHDF001DetermineInsurabilityRequest_TC_4.xml");
    }

    private void determineInsurability(String s) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .determineInsurability(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + s),
                                WZCMHDF001DetermineInsurabilityRequest.class), generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
        confirmTack(response.getTAckResponses().get(0));
        response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    private void assertTackRemoved(List<ProcessedTAckResponse> tAckResponses) {
        Assert.assertEquals("Tack should be removed", 0, tAckResponses.size());
    }

    private void confirmTacks(ProcessedGetResponse processedGetResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllTAcks(processedGetResponse);
        assertNotNull(confirmResponse);
    }

    private void confirmTack(ProcessedTAckResponse processedTAckResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(processedTAckResponse);
        assertNotNull(confirmResponse);
    }

    private void waitForTack() throws InterruptedException {
        TimeUnit.SECONDS.sleep(SECONDS_WAITING);
    }

    private InputReference generateInputReference() throws TechnicalConnectorException {
        // create a reference with format yyyyMMddHHmmss
        return new InputReference();
        // or:
        // return new InputReference("your custom reference");
    }
}
