package be.ehealth.businessconnector.vsbnet.async.session;

import be.cin.encrypted.EncryptedKnownContent;
import be.cin.nip.async.generic.ConfirmResponse;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedMsgResponse;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import be.vlaanderen.mercurius.insurability.schemas.v1.WZCMHDF001DetermineInsurabilityResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF101CreateApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF102CreateFictionalApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF103ConsultApplicationResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF104ConsultSupportAndRepairResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF105ReportDeliveryResponse;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF106PushDecisionRequest;
import be.vlaanderen.mercurius.mohm.schemas.v1.EMOHMDF107PushApplicationViewRequest;
import org.junit.Rule;
import org.junit.Test;

import java.util.Arrays;

import static org.junit.Assert.*;


/**
 * @author EHP
 */
public class VsbNetGetGenericAsyncIntegrationTest {

    private static final String RESPONSE_FOLDER = "/examples/vsbnet/async/response/";


    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();


    @Test
    public void getCreateApplication_TC_APP1() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withMaxMessages(20).withMaxTAcks(0).build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateApplication_TC_APP2() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withMaxMessages(20).withMaxTAcks(0).build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateApplication_TC_APP3() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateApplication_TC_APP4() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP4.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateApplication_TC_APP5() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withMaxMessages(1).withMaxTAcks(0).build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP5.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateApplication_TC_APP6() throws Exception {
        ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateApplication("EMOHMDF101CreateApplicationResponse_TC_APP6.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getConsultApplication_TC_CAPP1() throws Exception {
        ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withDefaults().build());
        assertConsultApplication("EMOHMDF103ConsultApplicationResponse_TC_CAPP1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);

    }

    @Test
    public void getConsultApplication_TC_CAPP2() throws Exception {
        ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultApplication(GetRequest.newBuilder().withDefaults().build());
        assertConsultApplication("EMOHMDF103ConsultApplicationResponse_TC_CAPP2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getReportDelivery_TC_DEL1() throws Exception {
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());
        assertReportDelivery("EMOHMDF105ReportDeliveryResponse_TC_DEL1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void _140_getReportDelivery_TC_DEL2() throws Exception {
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());
        assertReportDelivery("EMOHMDF105ReportDeliveryResponse_TC_DEL2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getReportDelivery_TC_DEL3() throws Exception {
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());
        assertReportDelivery("EMOHMDF105ReportDeliveryResponse_TC_DEL3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getReportDelivery_TC_DEL4() throws Exception {
        ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());
        assertReportDelivery("EMOHMDF105ReportDeliveryResponse_TC_DEL4.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getConsultSupportAndRepair_TC_CSUP1() throws Exception {
        ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withDefaults().build());
        assertConsultSupportAndRepair("EMOHMDF104ConsultSupportAndRepairResponse_TC_CSUP1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getConsultSupportAndRepair_TC_CSUP2() throws Exception {
        ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getConsultSupportAndRepair(GetRequest.newBuilder().withDefaults().build());
        assertConsultSupportAndRepair("EMOHMDF104ConsultSupportAndRepairResponse_TC_CSUP2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateFictionalApplicationResponse_TC_FAPP1() throws Exception {
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateFictionalApplication("EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateFictionalApplicationResponse_TC_FAPP2() throws Exception {
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateFictionalApplication("EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateFictionalApplicationResponse_TC_FAPP3() throws Exception {
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateFictionalApplication("EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getCreateFictionalApplicationResponse_TC_FAPP4() throws Exception {
        ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());
        assertCreateFictionalApplication("EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES1() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES2() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES3() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES4() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES4.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES5() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES5.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushDecision_TC_PDES6() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionRequest_TC_PDES6.xml", response);
    }

    @Test
    public void getPushDecision_TC_PDES7() throws Exception {
        ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushDecision(GetRequest.newBuilder().withDefaults().build());
        assertPushDecision("EMOHMDF106PushDecisionResponse_TC_PDES7.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getPushApplicationView_TC_PVIEW() throws Exception {
        ProcessedGetResponse<EMOHMDF107PushApplicationViewRequest> response = VsbNetSessionServiceFactory.getVsbNetMohmService()
                .getPushApplicationView(GetRequest.newBuilder().withDefaults().build());
        assertPushApplicationView("EMOHMDF107PushApplicationViewRequest_TC_PVIEW.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getListInvoiceFileAccepted() throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileAccepted(GetRequest.newBuilder().withDefaults().build());
        assertInvoiceList("921000_TC02.txt", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getListInvoiceAccepted1() throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted1(GetRequest.newBuilder().withDefaults().build());
        assertInvoiceList("920098_TC02.txt", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getListInvoiceAccepted2() throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceAccepted2(GetRequest.newBuilder().withDefaults().build());
        assertInvoiceList("920900_TC02.txt", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getListInvoiceRefused() throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceRefused(GetRequest.newBuilder().withDefaults().build());
        fail("not testable at the time of release 3.16.0-beta-3");
    }

    @Test
    public void getListInvoiceFileRefused() throws Exception {
        ProcessedGetResponse<byte[]> response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
                .getListInvoiceFileRefused(GetRequest.newBuilder().withMaxMessages(1).build());
        assertInvoiceList("920999_TC01.txt", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getDetermineInsurability_TC01() throws Exception {
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withReference("your TC01 reference").build());
        assertDetermineInsurability("WZCMHDF001DetermineInsurabilityResponse_TC_1.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getDetermineInsurability_TC02() throws Exception {
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withDefaults().build());
        assertDetermineInsurability("WZCMHDF001DetermineInsurabilityResponse_TC_2.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getDetermineInsurability_TC03() throws Exception {
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withDefaults().build());
        assertDetermineInsurability("WZCMHDF001DetermineInsurabilityResponse_TC_3.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    @Test
    public void getDetermineInsurability_TC04() throws Exception {
        ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
                .getDetermineInsurability(GetRequest.newBuilder().withDefaults().build());
        assertDetermineInsurability("WZCMHDF001DetermineInsurabilityResponse_TC_4.xml", response);
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService().confirmAllMessages(response);
        assertNotNull(confirmResponse);
    }

    private void assertCreateApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF101CreateApplicationResponse> response) throws Exception {
        EMOHMDF101CreateApplicationResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF101CreateApplicationResponse.class);
        for (ProcessedMsgResponse<EMOHMDF101CreateApplicationResponse> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF101CreateApplicationResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getCreateApplication().getVSBReference().equals(businessResponse.getCreateApplication().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertConsultApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF103ConsultApplicationResponse> response) throws Exception {
        EMOHMDF103ConsultApplicationResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF103ConsultApplicationResponse.class);
        for (ProcessedMsgResponse<EMOHMDF103ConsultApplicationResponse> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF103ConsultApplicationResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getConsultApplication().getVSBReference().equals(businessResponse.getConsultApplication().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertReportDelivery(String expectedResponse, ProcessedGetResponse<EMOHMDF105ReportDeliveryResponse> response) throws Exception {
        EMOHMDF105ReportDeliveryResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF105ReportDeliveryResponse.class);
        for (ProcessedMsgResponse<EMOHMDF105ReportDeliveryResponse> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF105ReportDeliveryResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getReportDelivery().getVSBReference().equals(businessResponse.getReportDelivery().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertConsultSupportAndRepair(String expectedResponse, ProcessedGetResponse<EMOHMDF104ConsultSupportAndRepairResponse> response) throws Exception {
        EMOHMDF104ConsultSupportAndRepairResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF104ConsultSupportAndRepairResponse.class);
        for (ProcessedMsgResponse<EMOHMDF104ConsultSupportAndRepairResponse> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF104ConsultSupportAndRepairResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getConsultSupportAndRepair().getVSBReference().equals(businessResponse.getConsultSupportAndRepair().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertCreateFictionalApplication(String expectedResponse, ProcessedGetResponse<EMOHMDF102CreateFictionalApplicationResponse> response) throws Exception {
        EMOHMDF102CreateFictionalApplicationResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF102CreateFictionalApplicationResponse.class);
        for (ProcessedMsgResponse<EMOHMDF102CreateFictionalApplicationResponse> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF102CreateFictionalApplicationResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getCreateFictionalApplication().getVSBReference().equals(businessResponse.getCreateFictionalApplication().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertPushDecision(String expectedResponse, ProcessedGetResponse<EMOHMDF106PushDecisionRequest> response) throws Exception {
        EMOHMDF106PushDecisionRequest expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF106PushDecisionRequest.class);
        for (ProcessedMsgResponse<EMOHMDF106PushDecisionRequest> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF106PushDecisionRequest businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getPushDecision().getVSBReference().equals(businessResponse.getPushDecision().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertPushApplicationView(String expectedResponse, ProcessedGetResponse<EMOHMDF107PushApplicationViewRequest> response) throws Exception {
        EMOHMDF107PushApplicationViewRequest expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), EMOHMDF107PushApplicationViewRequest.class);
        for (ProcessedMsgResponse<EMOHMDF107PushApplicationViewRequest> processedMsgResponse : response.getMsgResponses()) {
            EMOHMDF107PushApplicationViewRequest businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getPushApplication().getVSBReference().equals(businessResponse.getPushApplication().getVSBReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmMessage(processedMsgResponse);
                assertNotNull(confirmResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private void assertInvoiceList(String expectedResponse, ProcessedGetResponse<byte[]> response) throws Exception {
        byte[] expected = ConnectorIOUtils.getResourceAsByteArray(RESPONSE_FOLDER + expectedResponse);
        for (ProcessedMsgResponse<byte[]> processedMsgResponse : response.getMsgResponses()) {
            assertEquals(new String(expected), new String(processedMsgResponse.getBusinessResponse()));
            assertSignature(processedMsgResponse, false);
        }
    }

    private void assertDetermineInsurability(String expectedResponse, ProcessedGetResponse<WZCMHDF001DetermineInsurabilityResponse> response) throws Exception {
        WZCMHDF001DetermineInsurabilityResponse expected = ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(RESPONSE_FOLDER + expectedResponse), WZCMHDF001DetermineInsurabilityResponse.class);
        for (ProcessedMsgResponse<WZCMHDF001DetermineInsurabilityResponse> processedMsgResponse : response.getMsgResponses()) {
            WZCMHDF001DetermineInsurabilityResponse businessResponse = processedMsgResponse.getBusinessResponse();
            if (expected.getMessageMetadata().getCareProviderReference().equals(businessResponse.getMessageMetadata().getCareProviderReference())) {
                XmlAsserter.assertSimilar(expected, businessResponse);
                return;
            }
        }
        failNoMessageResponse();
    }

    private <T> void assertSignature(ProcessedMsgResponse<T> processedMsgResponse, boolean encrypted) {
        assertEquals("SignatureVerificationResult should contain no error", 0, processedMsgResponse.getSignatureVerificationResult().getErrors().size());
        assertNotNull("Missing xades", processedMsgResponse.getMsgResponse().getXadesT());
        if (encrypted) {
            XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(processedMsgResponse.getSignedData(), EncryptedKnownContent.class), processedMsgResponse.getRawDecryptedBlob());
        } else {
            assertTrue("Signed data and businessResponse content do not match", Arrays.equals((byte[]) processedMsgResponse.getBusinessResponse(), processedMsgResponse.getSignedData()));
        }
    }

    private void failNoMessageResponse() {
        fail("No message reponse");
    }

    private void confirmMsgResponses(ProcessedGetResponse processedGetResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(processedGetResponse);
        assertNotNull(confirmResponse);
    }
}
