/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mycarenet.memberdata.mock;

import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.BuilderStrategy;
import be.ehealth.businessconnector.mycarenet.memberdata.builders.RequestObjectBuilderFactory;
import be.ehealth.businessconnector.mycarenet.memberdata.exception.MemberDataBusinessConnectorException;
import be.ehealth.businessconnector.mycarenet.memberdata.session.AbstractBaseIntegrationTest;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.TemplateEngineUtils;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.MockServerRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.callbacks.AssertSOAPQueryCallback;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.callbacks.AssertStep;
import oasis.names.tc.saml._2_0.protocol.AttributeQuery;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

import java.util.HashMap;
import java.util.Map;

public class MemberDataMockSoapPhysicianTest extends AbstractBaseIntegrationTest {

    private static MockServerRule mockServerRule;

    static {
        try {
            Map<String, Object> velocityContext = new HashMap<String, Object>();
            velocityContext.put("sysdate", DateUtils.printDateTime(new DateTime()));
            velocityContext.put("sysdateplus", DateUtils.printDateTime(new DateTime().plusMinutes(1)));
            String kmehr = TemplateEngineUtils.generate(velocityContext, "/mock/callback/response/SessionSamlTokenResponse.xml");
            mockServerRule = new MockServerRule()
                    .addEndpointCallback("endpoint.sts", "/IAM/Saml11TokenService/v1",
                            new AssertSOAPQueryCallback(
                                    new AssertStep(
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/SessionSamlTokenRequestAsserter.xml"),
                                            kmehr,
                                            2)))
                    .addEndpointCallback("endpoint.etk", "/EtkDepot/v1",
                            new AssertSOAPQueryCallback(
                                    new AssertStep(
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/SessionETKRequestAsserter.xml"),
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/response/GetETKResponse.xml"),
                                            1),
                                    new AssertStep(
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/ReplyToETKRequestAsserter-OnlyForEncrypted.xml"),
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/response/GetReplyToETKResponse-OnlyForEncrypted.xml"),
                                            3
                                    )))
                    .addEndpointCallback("endpoint.memberdata", "/MyCareNet/MemberData/v1",
                            new AssertSOAPQueryCallback(
                                    new AssertStep(
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/MemberDataSyncRequestAsserter.xml"),
                                            ConnectorIOUtils.getResourceAsString("/mock/callback/response/MemberDataSyncAssertResponse.xml"),
                                            4)));
        } catch (TechnicalConnectorException e) {
            throw new RuntimeException(e);
        }
    }

    @ClassRule
    public static TestRule sessionRule = RuleChain
            .outerRule(mockServerRule)
            .around(SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes")
                    .withOverridingTestProperties(mockServerRule.getSessionProperties()).build());


    public MemberDataMockSoapPhysicianTest() throws TechnicalConnectorException {
        super(SessionUtil.getNihii11(), "67120143655");
    }

    @Test
    public void consultWithEncryptionTest() throws Exception {
        consultationTest(
                "/scenarios/requests/AttributeQuery-physician.xml",
                "/scenarios/response/physician/Response-physician-OA600-67120143655.xml",
                new BuilderStrategy() {
                    @Override
                    public MemberDataConsultationRequest build(boolean isTest, InputReference inputReference, AttributeQuery attributeQuery) throws MemberDataBusinessConnectorException, TechnicalConnectorException {
                        return RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildConsultationRequest(true, inputReference, attributeQuery);
                    }
                });
    }
}