/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.mycarenet.memberdata.builders;

import be.ehealth.businessconnector.mycarenet.memberdata.domain.MemberDataBuilderResponse;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.mycarenet.memberdata.protocol.v1.MemberDataConsultationResponse;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.AbstractSignatureTest;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

import java.io.InputStream;

/**
 * @author EH054
 */
public class ResponseObjectBuilderImplTest {

    @Test
    public void signaturesVerificationTest() throws Exception {
        ConfigFactory.getConfigValidator().setProperty("crypto.certificatechecker.classname", AbstractSignatureTest.CertificateCheckerStub.class.getName());

        InputStream is = ConnectorIOUtils.getResourceAsStream("/scenarios/response/SignaturesVerificationTest.xml");
        MemberDataConsultationResponse memberDataResponse = ConnectorXmlUtils.toObject(is, MemberDataConsultationResponse.class);
        IOUtils.closeQuietly(is);

        // Set Response to contain 9 assertion elements. Two of them are signed.
        memberDataResponse.getReturn().getDetail().setValue(("<ns3:Response ID=\"idvalue1\" InResponseTo=\"idvalue0\" Version=\"2.0\" IssueInstant=\"2017-07-11T12:00:01Z\" xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns4=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ns3=\"urn:oasis:names:tc:SAML:2.0:protocol\"><Issuer>urn:be:cin:io:100</Issuer><ns3:Status><ns3:StatusCode Value=\"urn:oasis:names:tc:2.0:status:Success\"/></ns3:Status><Assertion></Assertion><Assertion xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns3=\"http://www.w3.org/2001/04/xmlenc#\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc1\" IssueInstant=\"2017-07-11T12:00:01Z\" Version=\"2.0\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:insurability:patientData</ext:AssertionType><ext:Facet xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" id=\"urn:be:cin:nippin:insurability\"><Dimension xmlns=\"\" xmlns:ns12=\"urn:oasis:names:tc:SAML:2.0:assertion\" id=\"requestType\">information</Dimension><Dimension xmlns=\"\" xmlns:ns12=\"urn:oasis:names:tc:SAML:2.0:assertion\" id=\"contactType\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:fgov:person:ssin\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">79010501645</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:name\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">Vieilvoye</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:firstName\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">Anne</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:birthDate\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:date\">1979-01-05</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:gender\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">female</AttributeValue></Attribute></AttributeStatement><ds:Signature xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"xmldsig-dec6cefd-0b11-46d1-92e3-555ad1fbea16\">\n" +
                "<ds:SignedInfo>\n" +
                "<ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n" +
                "<ds:SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/>\n" +
                "<ds:Reference URI=\"#_a75adf55-01d7-40cc-929f-dbd8372ebdfc1\">\n" +
                "<ds:Transforms>\n" +
                "<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>\n" +
                "</ds:Transforms>\n" +
                "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n" +
                "<ds:DigestValue>v+mZKCIEHGJeKtv3mzCzOOH47aerpYSfjMqD45bEgAM=</ds:DigestValue>\n" +
                "</ds:Reference>\n" +
                "<ds:Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#xmldsig-7a806762-8da9-49fa-9f0a-d383c5b7025d-xades-signedprops\">\n" +
                "<ds:Transforms>\n" +
                "<ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n" +
                "</ds:Transforms>\n" +
                "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n" +
                "<ds:DigestValue>M6VI0lK/oRHdUyl10jADvY6qTY22X60chNJHCnVV8Uo=</ds:DigestValue>\n" +
                "</ds:Reference>\n" +
                "</ds:SignedInfo>\n" +
                "<ds:SignatureValue>\n" +
                "Nd7No/KSBEy2kRV2D8tZS7L7ce7GKdXzh9X4eIXpmm6r/79JpA1c+gqprdX9rRMLp4Csjb54to0W\n" +
                "6mY6jja96zVWPJKbSy5H05X0qFHDVWzeeysCgnkNvY4kVjI3zVxE7nH98C99PXlpA9oJRTqIVUt6\n" +
                "Z2k++xXA/XgMjWJoeL4WHV04gpW2SJOm9rvBU18ht2x59gQAiAcqjbLJy56oHNQXMho3Lz+WgU3G\n" +
                "XzI7D5AHpxAN2HRV1r6//oC83kBEs1bdiL8Dc8+B+DgWOkrd+QtrV0zuE91nWy/1Gj07KMhb0cBV\n" +
                "irPQL8HDmk0rJa1e4M1VNyMkqNFMrBqKYlLtWw==\n" +
                "</ds:SignatureValue>\n" +
                "<ds:KeyInfo>\n" +
                "<ds:X509Data>\n" +
                "<ds:X509Certificate>\n" +
                "MIIFLTCCAxWgAwIBAgIUIklNydfYmsLyaw29MNtH5POiXZMwDQYJKoZIhvcNAQELBQAwTjELMAkG\n" +
                "A1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJDAiBgNVBAMTG1F1b1ZhZGlzIE5v\n" +
                "IFJlbGlhbmNlIElDQSBHMzAeFw0xODA4MjMxMzE1NDhaFw0xOTA4MjMxMzI1MDBaMIGeMQswCQYD\n" +
                "VQQGEwJCRTEbMBkGA1UECgwSRmVkZXJhbCBHb3Zlcm5tZW50MRkwFwYDVQQLDBBTU0lOPTgyMDUx\n" +
                "MjM0OTc4MRkwFwYDVQQLDBBIQU5ORVMgREUgQ0xFUkNRMSEwHwYDVQQLDBhlSGVhbHRoLXBsYXRm\n" +
                "b3JtIEJlbGdpdW0xGTAXBgNVBAMMEFNTSU49ODIwNTEyMzQ5NzgwggEiMA0GCSqGSIb3DQEBAQUA\n" +
                "A4IBDwAwggEKAoIBAQCDwnXmslr7/6Fg2ATrC0pkMd//+bvEKVt2VFaa0nCl8V/f7+wu9iM1LTse\n" +
                "6mCw/cXHIFWVdv42tYLOppWO6QCWYM6+bC/s1I2QGpdNncli56JJs8pBnHN0AWD2mr7und51cgZb\n" +
                "Ej6MkcN+6Kko4TUuYovEcmiTC+7dPgWL8eSwuUMq7pq7UygDw5F1CFMDWODiYfFcEScfyh3DmlGu\n" +
                "TK1jbI7ZlwO0bFmAMbYzusiHe9qgEuTrlLjnnMNCmXRxXUXOST184vGiBWXrKProGNb3V0689/+n\n" +
                "RR6QKGz7Gt/qdAju0KcemYIeUMTKcPPqhB/GMczFoLfDu0B0goMq8IYHAgMBAAGjgbEwga4wHwYD\n" +
                "VR0jBBgwFoAUfLGnKDAXeXJ6aJ5qGQ/WbqE1yD4wPQYIKwYBBQUHAQEEMTAvMC0GCCsGAQUFBzAB\n" +
                "hiFodHRwOi8vb2NzcGRldi5xdW92YWRpc2dsb2JhbC5jb20wHQYDVR0lBBYwFAYIKwYBBQUHAwIG\n" +
                "CCsGAQUFBwMEMB0GA1UdDgQWBBR2Q0VoLUHT+FalKvZxCApJX7vEyTAOBgNVHQ8BAf8EBAMCBeAw\n" +
                "DQYJKoZIhvcNAQELBQADggIBACA0lKuXV+j+Fi4aPyovTZgLTmcSwVYZhAew4AtbKMAL3zdAIb1S\n" +
                "38jQ6grUEp7whCKUlQTnBP0/2/5X0Ptrznj25O04hw/DAUGKyfUGY4eck0d/6YTqSNykoWcprc4D\n" +
                "Vls6CVkHgAEyJopUp16HnRjYR5sAjHVotFs5lQpLFn/JSYyJMt6/BVF6J6ppFNCUpQHP9y9PDZWe\n" +
                "r/Gdvsp0Adi2gd3nxLwCC7mH0aqhBold0OisAySLKGggrmDFgqF0IxiIuckJDInD5DkD1fHz7CN4\n" +
                "YX9KCziBkl4ceetfHM6ugeR7j8AlyBtpZ10Bd/7MoGFgk9KiTkianASJI/IrxI7ixIAVcF5KWJ8n\n" +
                "qR3Kz00/7UVeHW7ydmnIahE/HCKHTiAFir4EGU1AuS/Yc/gGarCwfDOmL7dmmmdtToj8dSjaTxAa\n" +
                "BMSQnYDtCwPUNk7r8YfXx4rtU+vCDoSMG74IgYBbXlGlJAH58dY0UZOQ5MmkHTs5BxBbTj7bv2nJ\n" +
                "HXPfsrBDYyNcPcE9/nfjDLYoIN6pYTjWQMA2Zt6h/aRWRooBOjVgAawsgSMYRzG/g/zggm7Omfcc\n" +
                "SkwF7nyzSnAqz6mgZGASMl2JFprr65l+MqvJH85C/Fxgi+InyWt6UBdMwkte+VhjzzmiK+J+2hpj\n" +
                "qDsRUFCAAqdWgJMdsQkjwMEP\n" +
                "</ds:X509Certificate>\n" +
                "<ds:X509Certificate>\n" +
                "MIIGiDCCBHCgAwIBAgIUF7Q4gdFDVtDVQC9wqkx0KNOWxnUwDQYJKoZIhvcNAQELBQAweTELMAkG\n" +
                "A1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJTAjBgNVBAsTHFJvb3QgQ2VydGlm\n" +
                "aWNhdGlvbiBBdXRob3JpdHkxKDAmBgNVBAMTH1F1b1ZhZGlzIE5vIFJlbGlhbmNlIFJvb3QgQ0Eg\n" +
                "RzIwHhcNMTQxMTI2MTgzMTAzWhcNMTkxMTI2MTgzMTAzWjBOMQswCQYDVQQGEwJCTTEZMBcGA1UE\n" +
                "ChMQUXVvVmFkaXMgTGltaXRlZDEkMCIGA1UEAxMbUXVvVmFkaXMgTm8gUmVsaWFuY2UgSUNBIEcz\n" +
                "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAi63mQXjRU2ge4A90tgLMakg8AUYQcXmc\n" +
                "eeOsCPKACd3HLWFPHjPnA7vzJOIn0aJ3KLlsa5RYDcoVYC5VHh9GA+BFbYZcZV90zmeG7Z6KFvQ1\n" +
                "kEynky7W+XxKtv2hJ0K22Ae34148CE/1ZPp9bGB/7N8K42gn3g6EyMfT3wRoXpO+QIKUeRbyng+O\n" +
                "KP23as3Xbbf2rXQIsXsnjEnWP3fRQdTKTzeCgmSCqGe0dJdhGLkJdlJbNCopuKuBCDvXtOEmj8uK\n" +
                "FgOvMoYdl8anAm7R/io0BGk3f3qF8FDv1MimCh4/juXRE57Ofm9qhWTLF2XhaLh8aGb+LPEvtHjw\n" +
                "chSdtcerV3D+cxr/Xa9zCAD09zCNt+B7imtyh9TgsAfXyrdKUsqQsLbj/s+40An4T51LMj5ob815\n" +
                "56tJwlqQ4gkjWEF5H3qcRBrNTHCoV6f84jjcXYsZyzpDl7QeteqtVZlXQhk+fF4mXFDJUSjbNhNp\n" +
                "uMDGwvjYqyuJ8iEx9vy9zFX2Zr+t46K1CwWuRQfwkygV3A6by2m5jNE/UEtnm1cfUcXTzzhZ9HwD\n" +
                "JXLgBaALoAGlgwqQjEn+zBeHRSeuI+frDFAm6amMhJXfp/5SzM3TYrST0tRkerC9PE0M5sKQaQJq\n" +
                "+UgwSK/AankXyRDo4P2wiJgNiXeeXt4fm65F+Wv6HosCAwEAAaOCATEwggEtMBIGA1UdEwEB/wQI\n" +
                "MAYBAf8CAQAwEQYDVR0gBAowCDAGBgRVHSAAMHcGCCsGAQUFBwEBBGswaTAtBggrBgEFBQcwAYYh\n" +
                "aHR0cDovL29jc3BkZXYucXVvdmFkaXNnbG9iYWwuY29tMDgGCCsGAQUFBzAChixodHRwOi8vdHJ1\n" +
                "c3QucXVvdmFkaXNnbG9iYWwuY29tL3F2bnJjYWcyLmNydDAOBgNVHQ8BAf8EBAMCAQYwHwYDVR0j\n" +
                "BBgwFoAUr9DvHfgJ+TQRH9RXVvngO6ZhxDcwOwYDVR0fBDQwMjAwoC6gLIYqaHR0cDovL2NybC5x\n" +
                "dW92YWRpc2dsb2JhbC5jb20vcXZucmNhZzIuY3JsMB0GA1UdDgQWBBR8sacoMBd5cnponmoZD9Zu\n" +
                "oTXIPjANBgkqhkiG9w0BAQsFAAOCAgEAFwL6R3x+31pWHzG3qze/Q5aYTA7PZauk6TE4TXGD+rXd\n" +
                "LIONRbTvEvhRUOAEzXEO0gIVfd3oOEYN/bYKVCIwYlKvnb54ewxgN4x6YziWCFmDUHpFVhsQUqib\n" +
                "gxXQCSV53NmizrGSSPj7Qn6L95xBvjMfl6nl0qSphyPVKL7Y7iok7YohnVr4+IaQI1ifQNRZX4ir\n" +
                "LDKcmqMqKJPNaGUCGE8+Gq8aXZaXY7B7xDMTBEssWVt9gngflJNrMd+ULAE+BIkdAdfn/vdH0+RE\n" +
                "A3BA3sg9XQ3qPgWqBGk/BM+8hY/cTKBdNjE7fums3+YAqjYMPVK6pL1upg7KSqvf9WILr6gBAHi8\n" +
                "znup1ekXly66noFxDJsCqCA5SJUrylhOJlBR6giHhHpZE/07RgnEEdLU6fHAw3CMZCTfobq1FqIg\n" +
                "HqKt0Sn+ZaFwAuGmtWRcKSSOPNTqXcqkRAzn+7Oz9ZnbmjjmrpDkVMONVUROkmzbq/9AzL1X+zHA\n" +
                "c8tJnQzjW91L5KgpDe06foPR4WYQxOVsnxcuFdmUF6PsfVssbvWYyJBtFNKdjGApye7yE9Ev3XRG\n" +
                "hotxATDJ9BczqJDWHckT0MPFu3cDzbFFI21lQs0/QNR76TnNawG7tdCuNDHzL+KUrN9eNKL22sVL\n" +
                "X8rgXgdoZGe1tpqUCHfuSfh6rf5LEzw=\n" +
                "</ds:X509Certificate>\n" +
                "</ds:X509Data>\n" +
                "</ds:KeyInfo>\n" +
                "<ds:Object><QualifyingProperties xmlns=\"http://uri.etsi.org/01903/v1.3.2#\" Target=\"#xmldsig-dec6cefd-0b11-46d1-92e3-555ad1fbea16\"><SignedProperties Id=\"xmldsig-7a806762-8da9-49fa-9f0a-d383c5b7025d-xades-signedprops\"><SignedSignatureProperties><SigningTime>2018-08-27T14:10:05.416+02:00</SigningTime><SigningCertificate><Cert><CertDigest><ns2:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns2:DigestValue>JH1fxtjQaxe9cKJ8Tk3EaaFTqSioFU4Pkl5daSIcpJs=</ns2:DigestValue></CertDigest><IssuerSerial><ns2:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ns2:X509IssuerName><ns2:X509SerialNumber>195740416937184470112449663344384009701964275091</ns2:X509SerialNumber></IssuerSerial></Cert></SigningCertificate></SignedSignatureProperties></SignedProperties></QualifyingProperties></ds:Object>\n" +
                "</ds:Signature></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc2\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:insurability:period</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:insurability\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Dimension id=\"requestType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">information</Dimension><Dimension id=\"contactType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:careReceiver:registrationNumber\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">790105092m65</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:mutuality\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">130</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:cb1\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">110</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:cb2\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">110</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:communicationDate\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-07-11</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc3\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:insurability:payment</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:insurability\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Dimension id=\"requestType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">information</Dimension><Dimension id=\"contactType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:payment:byIO\"><AttributeValue xsi:type=\"xs:boolean\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">true</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc5\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:medicalHouse</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:insurability\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Dimension id=\"requestType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">information</Dimension><Dimension id=\"contactType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:medicalHouse:type\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">Medical</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:medicalHouse:start\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2016-11-01</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:medicalHouse:end\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-12-31</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc6\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:hospitalisation</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:insurability\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Dimension id=\"requestType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">information</Dimension><Dimension id=\"contactType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:hospitalisation:hospital:nihii11\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">71007661000</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:hospitalisation:service\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">38</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:hospitalisation:admissionDate\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-01-01</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfc7\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:carePath</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:carePath\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Dimension id=\"carePathType\" xmlns=\"\" xmlns:ns13=\"urn:oasis:names:tc:SAML:2.0:assertion\">diabetes</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:carePath:type\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">diabetes</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:carePath:physician:nihii11\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">16567303004</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:carePath:specialist:nihii11\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">17656275583</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:carePath:startRightDate\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-03-15</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:carePath:endContractDate\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-12-31</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:carePath:endRightDate\"><AttributeValue xsi:type=\"xs:date\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-12-31</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40cb-929f-dbd8372ebdfc6\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:chronicCondition</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:chronicCondition\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:chronicCondition:year\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017</AttributeValue></Attribute></AttributeStatement></Assertion><Assertion Version=\"2.0\" ID=\"_a75adf55-01d7-40bc-929f-dbd8372ebdfc6\" IssueInstant=\"2017-07-11T12:00:01Z\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:referencePharmacy</ext:AssertionType><ext:Facet id=\"urn:be:cin:nippin:referencePharmacy\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:cin:nippin:referencePharmacy:pharmacy:nihii8\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">66666417</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:referencePharmacy:startDate\"><AttributeValue xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">2017-03-15</AttributeValue></Attribute></AttributeStatement></Assertion>" +
                "<Assertion xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ns3=\"http://www.w3.org/2001/04/xmlenc#\" ID=\"_a75adf55-01d7-40cc-929f-dbd8372ebdfd1\" IssueInstant=\"2017-07-11T12:00:01Z\" Version=\"2.0\"><Issuer>urn:be:cin:io:100</Issuer><Subject><NameID Format=\"urn:be:cin:nippin:careReceiver:registrationNumber@mut\">790105092m65@100</NameID><SubjectConfirmation Method=\"urn:be:cin:nippin:memberIdentification\"><SubjectConfirmationData NotBefore=\"2017-07-11T00:00:00+02:00\" NotOnOrAfter=\"2017-07-12T00:00:00+02:00\"/></SubjectConfirmation></Subject><Advice><ext:AssertionType xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">urn:be:cin:nippin:insurability:patientData</ext:AssertionType><ext:Facet xmlns:common=\"urn:be:cin:mycarenet:esb:common:v2\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:ext=\"urn:be:cin:nippin:memberdata:saml:extension\" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" id=\"urn:be:cin:nippin:insurability\"><Dimension xmlns=\"\" xmlns:ns12=\"urn:oasis:names:tc:SAML:2.0:assertion\" id=\"requestType\">information</Dimension><Dimension xmlns=\"\" xmlns:ns12=\"urn:oasis:names:tc:SAML:2.0:assertion\" id=\"contactType\">hospitalized</Dimension>\n" +
                "\t\t\t</ext:Facet></Advice><AttributeStatement><Attribute Name=\"urn:be:fgov:person:ssin\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">79010501645</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:name\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">Vieilvoye</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:firstName\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">Anne</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:birthDate\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:date\">1979-01-05</AttributeValue></Attribute><Attribute Name=\"urn:be:cin:nippin:careReceiver:gender\"><AttributeValue xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xs:string\">female</AttributeValue></Attribute></AttributeStatement><ds:Signature xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"xmldsig-dec6cefd-0b11-46d1-92e3-555ad1fbea16\">\n" +
                "<ds:SignedInfo>\n" +
                "<ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n" +
                "<ds:SignatureMethod Algorithm=\"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256\"/>\n" +
                "<ds:Reference URI=\"#_a75adf55-01d7-40cc-929f-dbd8372ebdfd1\">\n" +
                "<ds:Transforms>\n" +
                "<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>\n" +
                "</ds:Transforms>\n" +
                "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n" +
                "<ds:DigestValue>v+mZKCIEHGJeKtv3mzCzOOH47aerpYSfjMqD45bEgAM=</ds:DigestValue>\n" +
                "</ds:Reference>\n" +
                "<ds:Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#xmldsig-7a806762-8da9-49fa-9f0a-d383c5b7025d-xades-signedprops\">\n" +
                "<ds:Transforms>\n" +
                "<ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/>\n" +
                "</ds:Transforms>\n" +
                "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n" +
                "<ds:DigestValue>M6VI0lK/oRHdUyl10jADvY6qTY22X60chNJHCnVV8Uo=</ds:DigestValue>\n" +
                "</ds:Reference>\n" +
                "</ds:SignedInfo>\n" +
                "<ds:SignatureValue>\n" +
                "Nd7No/KSBEy2kRV2D8tZS7L7ce7GKdXzh9X4eIXpmm6r/79JpA1c+gqprdX9rRMLp4Csjb54to0W\n" +
                "6mY6jja96zVWPJKbSy5H05X0qFHDVWzeeysCgnkNvY4kVjI3zVxE7nH98C99PXlpA9oJRTqIVUt6\n" +
                "Z2k++xXA/XgMjWJoeL4WHV04gpW2SJOm9rvBU18ht2x59gQAiAcqjbLJy56oHNQXMho3Lz+WgU3G\n" +
                "XzI7D5AHpxAN2HRV1r6//oC83kBEs1bdiL8Dc8+B+DgWOkrd+QtrV0zuE91nWy/1Gj07KMhb0cBV\n" +
                "irPQL8HDmk0rJa1e4M1VNyMkqNFMrBqKYlLtWw==\n" +
                "</ds:SignatureValue>\n" +
                "<ds:KeyInfo>\n" +
                "<ds:X509Data>\n" +
                "<ds:X509Certificate>\n" +
                "MIIFLTCCAxWgAwIBAgIUIklNydfYmsLyaw29MNtH5POiXZMwDQYJKoZIhvcNAQELBQAwTjELMAkG\n" +
                "A1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJDAiBgNVBAMTG1F1b1ZhZGlzIE5v\n" +
                "IFJlbGlhbmNlIElDQSBHMzAeFw0xODA4MjMxMzE1NDhaFw0xOTA4MjMxMzI1MDBaMIGeMQswCQYD\n" +
                "VQQGEwJCRTEbMBkGA1UECgwSRmVkZXJhbCBHb3Zlcm5tZW50MRkwFwYDVQQLDBBTU0lOPTgyMDUx\n" +
                "MjM0OTc4MRkwFwYDVQQLDBBIQU5ORVMgREUgQ0xFUkNRMSEwHwYDVQQLDBhlSGVhbHRoLXBsYXRm\n" +
                "b3JtIEJlbGdpdW0xGTAXBgNVBAMMEFNTSU49ODIwNTEyMzQ5NzgwggEiMA0GCSqGSIb3DQEBAQUA\n" +
                "A4IBDwAwggEKAoIBAQCDwnXmslr7/6Fg2ATrC0pkMd//+bvEKVt2VFaa0nCl8V/f7+wu9iM1LTse\n" +
                "6mCw/cXHIFWVdv42tYLOppWO6QCWYM6+bC/s1I2QGpdNncli56JJs8pBnHN0AWD2mr7und51cgZb\n" +
                "Ej6MkcN+6Kko4TUuYovEcmiTC+7dPgWL8eSwuUMq7pq7UygDw5F1CFMDWODiYfFcEScfyh3DmlGu\n" +
                "TK1jbI7ZlwO0bFmAMbYzusiHe9qgEuTrlLjnnMNCmXRxXUXOST184vGiBWXrKProGNb3V0689/+n\n" +
                "RR6QKGz7Gt/qdAju0KcemYIeUMTKcPPqhB/GMczFoLfDu0B0goMq8IYHAgMBAAGjgbEwga4wHwYD\n" +
                "VR0jBBgwFoAUfLGnKDAXeXJ6aJ5qGQ/WbqE1yD4wPQYIKwYBBQUHAQEEMTAvMC0GCCsGAQUFBzAB\n" +
                "hiFodHRwOi8vb2NzcGRldi5xdW92YWRpc2dsb2JhbC5jb20wHQYDVR0lBBYwFAYIKwYBBQUHAwIG\n" +
                "CCsGAQUFBwMEMB0GA1UdDgQWBBR2Q0VoLUHT+FalKvZxCApJX7vEyTAOBgNVHQ8BAf8EBAMCBeAw\n" +
                "DQYJKoZIhvcNAQELBQADggIBACA0lKuXV+j+Fi4aPyovTZgLTmcSwVYZhAew4AtbKMAL3zdAIb1S\n" +
                "38jQ6grUEp7whCKUlQTnBP0/2/5X0Ptrznj25O04hw/DAUGKyfUGY4eck0d/6YTqSNykoWcprc4D\n" +
                "Vls6CVkHgAEyJopUp16HnRjYR5sAjHVotFs5lQpLFn/JSYyJMt6/BVF6J6ppFNCUpQHP9y9PDZWe\n" +
                "r/Gdvsp0Adi2gd3nxLwCC7mH0aqhBold0OisAySLKGggrmDFgqF0IxiIuckJDInD5DkD1fHz7CN4\n" +
                "YX9KCziBkl4ceetfHM6ugeR7j8AlyBtpZ10Bd/7MoGFgk9KiTkianASJI/IrxI7ixIAVcF5KWJ8n\n" +
                "qR3Kz00/7UVeHW7ydmnIahE/HCKHTiAFir4EGU1AuS/Yc/gGarCwfDOmL7dmmmdtToj8dSjaTxAa\n" +
                "BMSQnYDtCwPUNk7r8YfXx4rtU+vCDoSMG74IgYBbXlGlJAH58dY0UZOQ5MmkHTs5BxBbTj7bv2nJ\n" +
                "HXPfsrBDYyNcPcE9/nfjDLYoIN6pYTjWQMA2Zt6h/aRWRooBOjVgAawsgSMYRzG/g/zggm7Omfcc\n" +
                "SkwF7nyzSnAqz6mgZGASMl2JFprr65l+MqvJH85C/Fxgi+InyWt6UBdMwkte+VhjzzmiK+J+2hpj\n" +
                "qDsRUFCAAqdWgJMdsQkjwMEP\n" +
                "</ds:X509Certificate>\n" +
                "<ds:X509Certificate>\n" +
                "MIIGiDCCBHCgAwIBAgIUF7Q4gdFDVtDVQC9wqkx0KNOWxnUwDQYJKoZIhvcNAQELBQAweTELMAkG\n" +
                "A1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJTAjBgNVBAsTHFJvb3QgQ2VydGlm\n" +
                "aWNhdGlvbiBBdXRob3JpdHkxKDAmBgNVBAMTH1F1b1ZhZGlzIE5vIFJlbGlhbmNlIFJvb3QgQ0Eg\n" +
                "RzIwHhcNMTQxMTI2MTgzMTAzWhcNMTkxMTI2MTgzMTAzWjBOMQswCQYDVQQGEwJCTTEZMBcGA1UE\n" +
                "ChMQUXVvVmFkaXMgTGltaXRlZDEkMCIGA1UEAxMbUXVvVmFkaXMgTm8gUmVsaWFuY2UgSUNBIEcz\n" +
                "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAi63mQXjRU2ge4A90tgLMakg8AUYQcXmc\n" +
                "eeOsCPKACd3HLWFPHjPnA7vzJOIn0aJ3KLlsa5RYDcoVYC5VHh9GA+BFbYZcZV90zmeG7Z6KFvQ1\n" +
                "kEynky7W+XxKtv2hJ0K22Ae34148CE/1ZPp9bGB/7N8K42gn3g6EyMfT3wRoXpO+QIKUeRbyng+O\n" +
                "KP23as3Xbbf2rXQIsXsnjEnWP3fRQdTKTzeCgmSCqGe0dJdhGLkJdlJbNCopuKuBCDvXtOEmj8uK\n" +
                "FgOvMoYdl8anAm7R/io0BGk3f3qF8FDv1MimCh4/juXRE57Ofm9qhWTLF2XhaLh8aGb+LPEvtHjw\n" +
                "chSdtcerV3D+cxr/Xa9zCAD09zCNt+B7imtyh9TgsAfXyrdKUsqQsLbj/s+40An4T51LMj5ob815\n" +
                "56tJwlqQ4gkjWEF5H3qcRBrNTHCoV6f84jjcXYsZyzpDl7QeteqtVZlXQhk+fF4mXFDJUSjbNhNp\n" +
                "uMDGwvjYqyuJ8iEx9vy9zFX2Zr+t46K1CwWuRQfwkygV3A6by2m5jNE/UEtnm1cfUcXTzzhZ9HwD\n" +
                "JXLgBaALoAGlgwqQjEn+zBeHRSeuI+frDFAm6amMhJXfp/5SzM3TYrST0tRkerC9PE0M5sKQaQJq\n" +
                "+UgwSK/AankXyRDo4P2wiJgNiXeeXt4fm65F+Wv6HosCAwEAAaOCATEwggEtMBIGA1UdEwEB/wQI\n" +
                "MAYBAf8CAQAwEQYDVR0gBAowCDAGBgRVHSAAMHcGCCsGAQUFBwEBBGswaTAtBggrBgEFBQcwAYYh\n" +
                "aHR0cDovL29jc3BkZXYucXVvdmFkaXNnbG9iYWwuY29tMDgGCCsGAQUFBzAChixodHRwOi8vdHJ1\n" +
                "c3QucXVvdmFkaXNnbG9iYWwuY29tL3F2bnJjYWcyLmNydDAOBgNVHQ8BAf8EBAMCAQYwHwYDVR0j\n" +
                "BBgwFoAUr9DvHfgJ+TQRH9RXVvngO6ZhxDcwOwYDVR0fBDQwMjAwoC6gLIYqaHR0cDovL2NybC5x\n" +
                "dW92YWRpc2dsb2JhbC5jb20vcXZucmNhZzIuY3JsMB0GA1UdDgQWBBR8sacoMBd5cnponmoZD9Zu\n" +
                "oTXIPjANBgkqhkiG9w0BAQsFAAOCAgEAFwL6R3x+31pWHzG3qze/Q5aYTA7PZauk6TE4TXGD+rXd\n" +
                "LIONRbTvEvhRUOAEzXEO0gIVfd3oOEYN/bYKVCIwYlKvnb54ewxgN4x6YziWCFmDUHpFVhsQUqib\n" +
                "gxXQCSV53NmizrGSSPj7Qn6L95xBvjMfl6nl0qSphyPVKL7Y7iok7YohnVr4+IaQI1ifQNRZX4ir\n" +
                "LDKcmqMqKJPNaGUCGE8+Gq8aXZaXY7B7xDMTBEssWVt9gngflJNrMd+ULAE+BIkdAdfn/vdH0+RE\n" +
                "A3BA3sg9XQ3qPgWqBGk/BM+8hY/cTKBdNjE7fums3+YAqjYMPVK6pL1upg7KSqvf9WILr6gBAHi8\n" +
                "znup1ekXly66noFxDJsCqCA5SJUrylhOJlBR6giHhHpZE/07RgnEEdLU6fHAw3CMZCTfobq1FqIg\n" +
                "HqKt0Sn+ZaFwAuGmtWRcKSSOPNTqXcqkRAzn+7Oz9ZnbmjjmrpDkVMONVUROkmzbq/9AzL1X+zHA\n" +
                "c8tJnQzjW91L5KgpDe06foPR4WYQxOVsnxcuFdmUF6PsfVssbvWYyJBtFNKdjGApye7yE9Ev3XRG\n" +
                "hotxATDJ9BczqJDWHckT0MPFu3cDzbFFI21lQs0/QNR76TnNawG7tdCuNDHzL+KUrN9eNKL22sVL\n" +
                "X8rgXgdoZGe1tpqUCHfuSfh6rf5LEzw=\n" +
                "</ds:X509Certificate>\n" +
                "</ds:X509Data>\n" +
                "</ds:KeyInfo>\n" +
                "<ds:Object><QualifyingProperties xmlns=\"http://uri.etsi.org/01903/v1.3.2#\" Target=\"#xmldsig-dec6cefd-0b11-46d1-92e3-555ad1fbea16\"><SignedProperties Id=\"xmldsig-7a806762-8da9-49fa-9f0a-d383c5b7025d-xades-signedprops\"><SignedSignatureProperties><SigningTime>2018-08-27T14:10:05.416+02:00</SigningTime><SigningCertificate><Cert><CertDigest><ns2:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/><ns2:DigestValue>JH1fxtjQaxe9cKJ8Tk3EaaFTqSioFU4Pkl5daSIcpJs=</ns2:DigestValue></CertDigest><IssuerSerial><ns2:X509IssuerName>CN=QuoVadis No Reliance ICA G3,O=QuoVadis Limited,C=BM</ns2:X509IssuerName><ns2:X509SerialNumber>195740416937184470112449663344384009701964275091</ns2:X509SerialNumber></IssuerSerial></Cert></SigningCertificate></SignedSignatureProperties></SignedProperties></QualifyingProperties></ds:Object>\n" +
                "</ds:Signature></Assertion>" +
                "</ns3:Response>").getBytes("UTF-8"));


        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        MemberDataBuilderResponse builderResponse = responseBuilder.handleConsultationResponse(memberDataResponse);

        SignatureVerificationResult success = builderResponse.getSignatureVerificationResult().get("_a75adf55-01d7-40cc-929f-dbd8372ebdfc1");
        SignatureVerificationResult failure = builderResponse.getSignatureVerificationResult().get("_a75adf55-01d7-40cc-929f-dbd8372ebdfd1");

        Assert.assertEquals(2, builderResponse.getSignatureVerificationResult().size());
        Assert.assertEquals("Unexpected error found in the verification results", 0, success.getErrors().size());
        Assert.assertEquals("Unexpected success found in the verification results", 1, failure.getErrors().size());
    }

}
