/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dicsv3.session;

import static be.ehealth.businessconnector.testcommons.utils.MarshallerUtils.toObject;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

import be.fgov.ehealth.dics.protocol.v3.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v3.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v3.FindCommentedClassificationRequest;
import be.fgov.ehealth.dics.protocol.v3.FindCommentedClassificationResponse;
import be.fgov.ehealth.dics.protocol.v3.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v3.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v3.FindCompoundingFormulaRequest;
import be.fgov.ehealth.dics.protocol.v3.FindCompoundingFormulaResponse;
import be.fgov.ehealth.dics.protocol.v3.FindCompoundingIngredientRequest;
import be.fgov.ehealth.dics.protocol.v3.FindCompoundingIngredientResponse;
import be.fgov.ehealth.dics.protocol.v3.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v3.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v3.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v3.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v3.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v3.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v3.FindVmpGroupRequest;
import be.fgov.ehealth.dics.protocol.v3.FindVmpGroupResponse;
import be.fgov.ehealth.dics.protocol.v3.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v3.FindVmpResponse;
import be.fgov.ehealth.dics.protocol.v3.FindVtmRequest;
import be.fgov.ehealth.dics.protocol.v3.FindVtmResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

/**
 * Integration tests for tarification.
 * 
 * @author EHP
 * 
 */
public final class DicsIntegrationTest {

    @ClassRule
    public static SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.dicsv3.test.properties").build();


    @Test
    public void findAmpTestXmlNoDataFound() throws Exception {
        FindAmpResponse response = findAmpTest("/examples/findAmpRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findAmpTestXml() throws Exception {
        FindAmpResponse response = findAmpTest("/examples/findAmpRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No amps found", response.getAmps().size() >= 1);
    }

    private FindAmpResponse findAmpTest(String location) throws Exception {
        FindAmpRequest request = toObject(location, FindAmpRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findAmp(request);
    }

    @Test
    public void findCommentedClassificationXmlNoDataFound() throws Exception {
        FindCommentedClassificationResponse response = findCommentedClassification("/examples/findCommentedClassificationRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    @Ignore("Waiting for service to provide data")
    public void findCommentedClassificationXml() throws Exception {
        FindCommentedClassificationResponse response = findCommentedClassification("/examples/findCommentedClassificationRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getCommentedClassifications().size() >= 1);
    }

    private FindCommentedClassificationResponse findCommentedClassification(String location) throws Exception {
        FindCommentedClassificationRequest request = toObject(location, FindCommentedClassificationRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findCommentedClassification(request);
    }

    @Test
    public void findCompanyXmlNoDataFound() throws Exception {
        FindCompanyResponse response = findCompany("/examples/findCompanyRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findCompanyXml() throws Exception {
        FindCompanyResponse response = findCompany("/examples/findCompanyRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No companies found", response.getCompanies().size() >= 1);
    }

    private FindCompanyResponse findCompany(String location) throws Exception {
        FindCompanyRequest request = toObject(location, FindCompanyRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findCompany(request);
    }

    @Test
    public void findFormulaXmlNoDataFound() throws Exception {
        FindCompoundingFormulaResponse response = findFormula("/examples/findFormulaRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    @Ignore("Waiting for service to provide data")
    public void findFormulaXml() throws Exception {
        FindCompoundingFormulaResponse response = findFormula("/examples/findFormulaRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getCompoundingFormulas().size() >= 1);
    }

    private FindCompoundingFormulaResponse findFormula(String location) throws Exception {
        FindCompoundingFormulaRequest request = toObject(location, FindCompoundingFormulaRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findFormula(request);
    }

    @Test
    public void findIngredientXmlNoDataFound() throws Exception {
        FindCompoundingIngredientResponse response = findIngredient("/examples/findIngredientRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    @Ignore("Waiting for service to provide data")
    public void findIngredientXml() throws Exception {
        FindCompoundingIngredientResponse response = findIngredient("/examples/findIngredientRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getCompoundingIngredients().size() >= 1);
    }

    private FindCompoundingIngredientResponse findIngredient(String location) throws Exception {
        FindCompoundingIngredientRequest request = toObject(location, FindCompoundingIngredientRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findIngredient(request);
    }

    @Test
    public void findLegislationXmlNoDataFound() throws Exception {
        FindLegislationTextResponse response = findLegislation("/examples/findLegislationTextRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findLegislationXml() throws Exception {
        FindLegislationTextResponse response = findLegislation("/examples/findLegislationTextRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getLegalbases().size() >= 1);
    }

    private FindLegislationTextResponse findLegislation(String location) throws Exception {
        FindLegislationTextRequest request = toObject(location, FindLegislationTextRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findLegislationText(request);
    }

    @Test
    public void findReferencesXml() throws Exception {
        FindReferencesResponse response = findReferences("/examples/findReferencesRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getWadas().size() >= 1);
    }

    private FindReferencesResponse findReferences(String location) throws Exception {
        FindReferencesRequest request = toObject(location, FindReferencesRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findReferences(request);
    }

    @Test
    public void findReimboursementXmlNoDataFound() throws Exception {
        FindReimbursementResponse response = findReimboursement("/examples/findReimboursementRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    @Ignore("Waiting for service to provide data")
    public void findReimboursementXml() throws Exception {
        FindReimbursementResponse response = findReimboursement("/examples/findReimboursementRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getReimbursementContexts().size() >= 1);
    }

    private FindReimbursementResponse findReimboursement(String location) throws Exception {
        FindReimbursementRequest request = toObject(location, FindReimbursementRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findReimbursement(request);
    }

    @Test
    public void findVmpGroupXmlNoDataFound() throws Exception {
        FindVmpGroupResponse response = findVmpGroup("/examples/findVmpGroupRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findVmpGroupXml() throws Exception {
        FindVmpGroupResponse response = findVmpGroup("/examples/findVmpGroupRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getVmpGroups().size() >= 1);
    }

    private FindVmpGroupResponse findVmpGroup(String location) throws Exception {
        FindVmpGroupRequest request = toObject(location, FindVmpGroupRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVmpGroup(request);
    }

    @Test
    public void findVmpXmlNoDataFound() throws Exception {
        FindVmpResponse response = findVmp("/examples/findVmpRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findVmpXml() throws Exception {
        FindVmpResponse response = findVmp("/examples/findVmpRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getVmps().size() >= 1);
    }

    private FindVmpResponse findVmp(String location) throws Exception {
        FindVmpRequest request = toObject(location, FindVmpRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVmp(request);
    }

    @Test
    public void findVtmXmlNoDataFound() throws Exception {
        FindVtmResponse response = findVtm("/examples/findVtmRequest-noDataFound.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertEquals("The second status is not a data not found", "urn:be:fgov:ehealth:2.0:status:DataNotFound", response.getStatus().getStatusCode().getStatusCode().getValue());
    }

    @Test
    public void findVtmXml() throws Exception {
        FindVtmResponse response = findVtm("/examples/findVtmRequest.xml");

        Assert.assertEquals("The status is not a success", "urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue());
        Assert.assertNull("The status is not a success", response.getStatus().getStatusCode().getStatusCode());
        Assert.assertTrue("No commented classification found", response.getVtms().size() >= 1);
    }

    private FindVtmResponse findVtm(String location) throws Exception {
        FindVtmRequest request = toObject(location, FindVtmRequest.class);

        return DicsSessionServiceFactory.getDicsSession().findVtm(request);
    }
}

