/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.attest.session.mock;

import be.ehealth.businessconnector.attest.session.AttestIntegrationTest;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.utils.TemplateEngineUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.MockServerRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.callbacks.AssertSOAPQueryCallback;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.callbacks.AssertStep;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Ignore("certificate expired in mocked response signature not handled")
@RunWith(Parameterized.class)
public class AttestMockSoapTest {
    
    private static MockServerRule mockServerRule;

    
    // TODO investigate: has failed with java.lang.NoClassDefFoundError: be/ehealth/technicalconnector/config/impl/ConfigurationModuleTrustStore$TrustStoreTimerEnum
//    static {
//        try {
//            Map<String, Object> velocityContext = new HashMap<String, Object>();
//            velocityContext.put("sysdate", DateUtils.printDateTime(new DateTime()));
//            velocityContext.put("sysdateplus", DateUtils.printDateTime(new DateTime().plusMinutes(1)));
//            String kmerh = TemplateEngineUtils.generate(velocityContext, "/mock/callback/response/SessionSamlTokenResponse.xml");
//            mockServerRule = new MockServerRule()
//                        .addEndpointCallback("endpoint.sts", "/IAM/Saml11TokenService/v1",
//                                new AssertSOAPQueryCallback(
//                                        new AssertStep(
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/SessionSamlTokenRequestAsserter.xml"),
//                                                kmerh,
//                                                2)))
//                        .addEndpointCallback("endpoint.etk", "/EtkDepot/v1",
//                                new AssertSOAPQueryCallback(
//                                        new AssertStep(
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/SessionETKRequestAsserter.xml"),
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/response/GetETKResponse.xml"),
//                                                1),
//                                        new AssertStep(
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/ReplyToETKRequestAsserter.xml"),
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/response/GetReplyToETKResponse.xml"),
//                                                3)))
//                        .addEndpointCallback("endpoint.attest", "/MyCareNet/eAttest/v1",
//                                new AssertSOAPQueryCallback(
//                                        new AssertStep(
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/asserter/AttestRequestAsserter.xml"),
//                                                ConnectorIOUtils.getResourceAsString("/mock/callback/response/AssertResponse.xml"),
//                                                4)));
//        } catch (TechnicalConnectorException e) { 
//            throw new RuntimeException(e);
//        }
//    }
//
//    @ClassRule
//    public static TestRule sessionRule = RuleChain
//            .outerRule(mockServerRule)
//            .around(SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").withOverridingTestProperties(mockServerRule.getSessionProperties()).build());
    

    @Parameterized.Parameters(name = "{0},{1},{2}")
    public static Collection<Object[]> data() {
        Collection<Object[]> testData = new ArrayList<Object[]>();
        testData.add(new Object[]{"600", "53081411750", "18", "10830643004"});
        return testData;

    }

    private String ssin;
    private String scenarioId;
    private String oa;
    private String dmgManager;


    public AttestMockSoapTest(String oa, String ssin, String scenarioId, String dmgManager)  {
        super();
        this.ssin = ssin;
        this.scenarioId = scenarioId;
        this.oa = oa;
        this.dmgManager = dmgManager;
    }

    @Test
    @Ignore
    public void sendAttestationTest() throws Exception {
        new AttestIntegrationTest(oa, ssin, scenarioId, dmgManager).sendAttestationTest();
    }
}