/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.vsbnetinsurability.helper;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityResponse;
import org.junit.Test;

import java.io.InputStream;


/**
 * tests the ResponseHelper, a class that validates the xml of a response.
 * 
 * @author EHP
 */
public class ResponseHelperTest {

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.vsbnetinsurability.helper.ResponseHelper#validateResponse(be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityResponse)}
     * .
     */
    @Test
    public void testValidateResponse() throws Exception {
        InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/response/validatorTest.xml");
        GetInsurabilityResponse response = ConnectorXmlUtils.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream), GetInsurabilityResponse.class);
        ResponseHelper.validateResponse(response);
    }

}
