/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.InstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ConnectorXmlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorXmlUtils.class);

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConnectorXmlUtils() {
        throw new UnsupportedOperationException();
    }

    public static Element getFirstElementByTagNameNS(Element node, String namespaceURI, String localName) {
        NodeList nodeList = node.getElementsByTagNameNS(namespaceURI, localName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            LOG.debug("{}:{} elements count: ,returning first one", new Object[]{namespaceURI, localName, nodeList.getLength()});
        }
        return (Element)nodeList.item(0);
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    @Deprecated
    public static void logXmlObject(Object obj) {
        ConnectorXmlUtils.dump(obj);
    }

    public static void dump(Object obj) {
        if (LOG.isDebugEnabled()) {
            try {
                if (obj != null) {
                    String xmlString = ConnectorXmlUtils.toString(obj);
                    LOG.debug("Contents of " + obj.getClass().getCanonicalName() + "  : " + xmlString + "");
                }
            }
            catch (Exception e) {
                LOG.error("Error occured while logging contents of object " + obj.getClass().getCanonicalName() + ". Reason: " + e.getMessage());
            }
        }
    }

    @Deprecated
    public static String marshal(Object obj) {
        return ConnectorXmlUtils.toString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static byte[] toByteArray(Node node) {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        try {
            DOMSource source = new DOMSource(node);
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            byArray = out.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            ConnectorIOUtils.closeQuietly((Object)out);
        }
        catch (TransformerException e2) {
            LOG.error(e2.getClass().getSimpleName() + ":" + e2.getMessage());
            {
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            ConnectorIOUtils.closeQuietly((Object)out);
        }
        ConnectorIOUtils.closeQuietly((Object)out);
        return byArray;
        return null;
    }

    public static byte[] toByteArray(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toXMLByteArray(obj);
    }

    @Deprecated
    public static byte[] toByteArray(Object data, QName rootTag) {
        MarshallerHelper marshaller = new MarshallerHelper(data.getClass(), data.getClass());
        return marshaller.toXMLByteArrayNoRootElementRequired(data);
    }

    public static Document toDocument(byte[] data) throws TechnicalConnectorException {
        Document document;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(data);
            document = ConnectorXmlUtils.getDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            try {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)in);
        return document;
    }

    public static Document toDocument(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toDocument(obj);
    }

    public static Document toDocument(String xml) throws TechnicalConnectorException {
        try {
            return ConnectorXmlUtils.parseXmlFile(xml);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Element toElement(byte[] data) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toDocument(data).getDocumentElement();
    }

    public static <T> T toObject(InputStream in, Class<T> clazz) throws Exception {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(in);
    }

    public static <T> T toObject(byte[] in, Class<T> clazz) {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(in);
    }

    public static <T> T toObject(String xml, Class<T> clazz) throws Exception {
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        return helper.toObject(xml);
    }

    public static String toString(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toString(obj);
    }

    public static String toString(Node node) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toString(new DOMSource(node));
    }

    public static String toString(Source source) throws TechnicalConnectorException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(outputStream);
            tf.transform(source, result);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)outputStream);
        }
    }

    public static String flatten(String xml) {
        String result = xml.replaceAll("[\t\n\r]", "");
        while (result.contains(" <")) {
            result = result.replace(" <", "<");
        }
        return result;
    }

    public static String format(String unformattedXml) {
        return ConnectorXmlUtils.format(unformattedXml, null);
    }

    public static String format(String unformattedXml, Source xslt) {
        try {
            Document doc = ConnectorXmlUtils.parseXmlFile(unformattedXml);
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = xslt != null ? tf.newTransformer(xslt) : tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(1));
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new InstantiationException(e);
        }
    }

    private static Document parseXmlFile(String in) {
        try {
            InputSource is = new InputSource(new StringReader(in));
            return ConnectorXmlUtils.getDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new InstantiationException(e);
        }
    }

    @Deprecated
    public static boolean isXMLLike(String inXMLStr) {
        try {
            ConnectorXmlUtils.parseXmlFile(inXMLStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

