/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.decrypt.SigningTimeVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.TimeStampTrustResult;
import be.fgov.ehealth.etee.crypto.decrypt.TimeStampTrustService;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import be.fgov.ehealth.etee.crypto.policies.SigningOptions;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import be.fgov.ehealth.etee.crypto.utils.TimeFrameValidator;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.tsp.TimeStampToken;

class SigningTimeVerifier {
    private static final Logger LOGGER = Logger.getLogger(SigningTimeVerifier.class);
    private TimeFrameValidator timeFrameValidator;
    private int signingTimeExpiration;
    private TimeStampTrustService timeStampTrustService;

    public SigningTimeVerifier() {
        this(SigningOptions.defaultOptions(), null);
    }

    public SigningTimeVerifier(SigningOptions signingOptions, TimeStampTrustService timeStampTrustService) {
        Long clockSkew = signingOptions.getLong(SigningOption.CLOCK_SKEW);
        this.signingTimeExpiration = signingOptions.getInteger(SigningOption.SIGNING_TIME_EXPIRATION);
        boolean signingTimeTrustImplicit = signingOptions.getBoolean(SigningOption.SIGNING_TIME_TRUST_IMPLICIT);
        if (!signingTimeTrustImplicit) {
            this.timeFrameValidator = TimeFrameValidator.create(clockSkew);
        }
        this.timeStampTrustService = timeStampTrustService;
    }

    SigningTimeVerifierResult verify(SignerInfoAttributes signerInfoAttributes) {
        Date signingTime = signerInfoAttributes.getSigningTime();
        if (signingTime == null) {
            LOGGER.info((Object)"No SignerInfo Attribute found with Signing-Time");
            return this.handleSigningTimeMissing(signerInfoAttributes);
        }
        Date now = new Date();
        Date expirationTime = this.getExpiration(this.signingTimeExpiration, now);
        if (!this.validateExpirationTime(expirationTime, signingTime, now)) {
            LOGGER.info((Object)("SignerInfo Attribute found with expired Signing-Time: " + signingTime));
            return this.handlesigningTimeExpired(signerInfoAttributes, signingTime, now);
        }
        LOGGER.info((Object)("Message Signing-Time accepted as is: " + signingTime));
        return new SigningTimeVerifierResult(signingTime);
    }

    private SigningTimeVerifierResult handleSigningTimeMissing(SignerInfoAttributes signerInfoAttributes) {
        Date signingTime = null;
        if (signerInfoAttributes.getSignatureTimestamps().isEmpty()) {
            return this.buildResult(signingTime, NotificationWarning.SIGNING_TIME_MISSING, "No SignerInfo Attribute found with Signature-TimeStampToken");
        }
        if (!this.supportsTimeStamps()) {
            return this.buildResult(signingTime, NotificationWarning.SIGNING_TIME_MISSING, "Trust for Signature-TimeStampTokens is disabled.");
        }
        TimeStampToken timeStampToken = signerInfoAttributes.getSignatureTimestamps().get(0);
        TimeStampTrustResult tsResult = this.timeStampTrustService.verify(timeStampToken, this.getX509CRL(signerInfoAttributes.getCrls()));
        if (tsResult.hasErrors()) {
            return this.buildResult(signingTime, tsResult.getErrors(), "TimeStampToken validation completed with errors");
        }
        signingTime = timeStampToken.getTimeStampInfo().getGenTime();
        LOGGER.info((Object)("Found a valid Signature-TimeStampToken. Using generated time of timestamp as Signing-Time: " + signingTime));
        SigningTimeVerifierResult result = new SigningTimeVerifierResult(signingTime);
        if (tsResult.hasWarnings()) {
            LOGGER.error((Object)("TimeStampToken validation completed with warnings: " + tsResult.getWarnings()));
            result.getWarnings().addAll(tsResult.getWarnings());
        }
        return result;
    }

    private SigningTimeVerifierResult handlesigningTimeExpired(SignerInfoAttributes signerInfoAttributes, Date signingTime, Date now) {
        if (signerInfoAttributes.getSignatureTimestamps().isEmpty()) {
            return this.buildResult(signingTime, NotificationWarning.SIGNING_TIME_EXPIRED, "Signing-Time is expired " + signingTime + " with respect to the current time and no Signature-TimeStampToken found - " + now);
        }
        if (!this.supportsTimeStamps()) {
            return this.buildResult(signingTime, NotificationWarning.SIGNING_TIME_EXPIRED, "Trust for Signature-TimeStampTokens is disabled.");
        }
        TimeStampToken timeStampToken = signerInfoAttributes.getSignatureTimestamps().get(0);
        TimeStampTrustResult tsResult = this.timeStampTrustService.verify(timeStampToken, this.getX509CRL(signerInfoAttributes.getCrls()));
        if (tsResult.hasErrors()) {
            return this.buildResult(signingTime, tsResult.getErrors(), "TimeStampToken validation completed with errors");
        }
        Date timeStampGenerationTime = timeStampToken.getTimeStampInfo().getGenTime();
        Date expirationTime = this.getExpiration(this.signingTimeExpiration, timeStampGenerationTime);
        if (!this.validateExpirationTime(expirationTime, signingTime, timeStampGenerationTime)) {
            return this.buildResult(signingTime, NotificationWarning.SIGNING_TIME_EXPIRED, "Signing-Time is expired " + signingTime + " with respect to the Signature-TimeStamp - " + timeStampGenerationTime);
        }
        LOGGER.info((Object)("Found a valid Signature-TimeStampToken close to the Signing-Time. Signing-Time accepted: " + signingTime));
        SigningTimeVerifierResult result = new SigningTimeVerifierResult(signingTime);
        if (tsResult.hasWarnings()) {
            LOGGER.error((Object)("TimeStampToken validation completed with warnings: " + tsResult.getWarnings()));
            result.getWarnings().addAll(tsResult.getWarnings());
        }
        return result;
    }

    private SigningTimeVerifierResult buildResult(Date signingTime, NotificationWarning warning, String msg) {
        LOGGER.warn((Object)msg);
        SigningTimeVerifierResult result = new SigningTimeVerifierResult(signingTime);
        result.getWarnings().add(warning);
        return result;
    }

    private SigningTimeVerifierResult buildResult(Date signingTime, List<NotificationError> errors, String msg) {
        LOGGER.error((Object)(msg + ": " + errors));
        SigningTimeVerifierResult result = new SigningTimeVerifierResult(signingTime);
        result.getErrors().addAll(errors);
        return result;
    }

    private boolean supportsTimeStamps() {
        return this.timeStampTrustService != null;
    }

    private boolean validateExpirationTime(Date expiration, Date signingTime, Date now) {
        if (this.timeFrameValidator == null) {
            return true;
        }
        return this.timeFrameValidator.validate(expiration, signingTime, now);
    }

    private Date getExpiration(int max, Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, -max);
        return c.getTime();
    }

    private List<X509CRL> getX509CRL(List<CertificateList> crls) {
        ArrayList<X509CRL> x509Crls = new ArrayList<X509CRL>();
        for (CertificateList crl : crls) {
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(crl.getEncoded());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                x509Crls.add((X509CRL)cf.generateCRL(inStream));
                inStream.close();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Embedded CRL could not be encoded. It will be skipped.", (Throwable)e);
            }
        }
        return x509Crls;
    }
}

