/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.registration.session;

import be.ehealth.business.mycarenetcommons.builders.ResponseBuilder;
import be.ehealth.business.mycarenetcommons.builders.ResponseBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.ehealth.business.mycarenetdomaincommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.registration.builder.RegistrationRequestBuilderFactory;
import be.ehealth.businessconnector.registration.builder.RequestBuilder;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.mycarenet.registration.protocol.v1.RegisterToMycarenetServiceRequest;
import be.fgov.ehealth.mycarenet.registration.protocol.v1.RegisterToMycarenetServiceResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;


/**
 * Integration test for registration.
 * 
 * @author eHealth Platform
 * 
 */
public class RegistrationIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(RegistrationIntegrationTest.class);

    @BeforeClass
    public static final void setupsession() throws Exception {
        LOG.debug("DmgAsyncIntegrationTest.loadSession:");
        SessionInitializer.init("/be.ehealth.businessconnector.registration.test.properties");
    }

    @AfterClass
    public static final void teardownSession() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void registerOA100Test() throws Exception {
        testOa("100");
    }

    @Test
    public void registerOA300Test() throws Exception {
        testOa("300");
    }

    @Test
    public void registerOA500Test() throws Exception {
        testOa("500");
    }

    @Test
    @Ignore("never works in pilot")
    public void registerOA600Test() throws Exception {
        testOa("600");
    }

    @Test
    @Ignore("never works in pilot")
    public void registerOA900Test() throws Exception {
        testOa("900");
    }

    /**
     * @param oa
     */
    private void testOa(String oa) throws Exception {

        RegisterToMycarenetServiceResponse response = getResponse(oa);

        ResponseBuilder responseBuilder = ResponseBuilderFactory.getResponseBuilder("mcn.registration");

        String xmlValue = responseBuilder.getResponse(response);
        LOG.debug("returned xml value : \n" + xmlValue);
        Assert.assertNotNull(xmlValue);
    }


    /**
     * @param oa
     * @return
     * @throws TechnicalConnectorException
     * @throws InvalidBlobContentConnectorException
     * @throws ConnectorException
     */
    private RegisterToMycarenetServiceResponse getResponse(String oa) throws TechnicalConnectorException, InvalidBlobContentConnectorException, ConnectorException {
        RequestBuilder mapper = RegistrationRequestBuilderFactory.getRequestObjectBuilder();
        CommonInput commonInput = RequestBuilderFactory.getCommonBuilder("mcn.registration").createCommonInput(McnConfigUtil.retrievePackageInfo("mcn.registration"), false, IdGeneratorFactory.getIdGenerator().generateId());

        InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/DetailContentOfExamplesRegistrationRequest.xml");
        String testFileContent = new String(ConnectorIOUtils.getBytes(businessXmlContentStream));
        testFileContent = testFileContent.replaceAll("replaceWithDateYYYY-MM-DD", new DateTime().toString("YYYY-MM-dd"));
        testFileContent = testFileContent.replaceAll("replaceWithNihiiNumber", SessionUtil.getNihii11());
        LOG.debug("used content : \n" + testFileContent);
        Blob blob = BlobBuilderFactory.getBlobBuilder("mcn.registration").build(testFileContent.getBytes());
        RegisterToMycarenetServiceRequest request = mapper.buildRegisterToMycarenetRequest(commonInput, getRouting(oa), blob, null);
        RegistrationSession session = RegistrationSessionFactory.getRegistrationSession();

        RegisterToMycarenetServiceResponse response = session.registerToMycarenetService(request);
        return response;
    }


    private static Routing getRouting(String oa) {
        CareReceiverId careReceiver = new CareReceiverId(null);
        careReceiver.setMutuality(oa);
        return new Routing(careReceiver, new DateTime());
    }

}
