package be.ehealth.businessconnector.hubv3.session.orgpharmacy;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.businessconnector.hubv3.helpers.HubConfigVitalink;
import be.ehealth.businessconnector.hubv3.helpers.HubTestHelper;
import be.ehealth.businessconnector.hubv3.session.HubService;
import be.ehealth.businessconnector.hubv3.session.InitHubRule;
import be.ehealth.businessconnector.hubv3.session.InitVitalinkHubRule;
import be.ehealth.businessconnector.testcommons.BusinessSessionRule;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.hubservices.core.v3.GetLatestUpdateResponse;
import be.fgov.ehealth.hubservices.core.v3.GetPatientAuditTrailResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionListResponse;
import be.fgov.ehealth.hubservices.core.v3.GetTransactionSetResponse;
import be.fgov.ehealth.hubservices.core.v3.LocalSearchType;
import be.fgov.ehealth.hubservices.core.v3.PatientIdType;
import be.fgov.ehealth.hubservices.core.v3.PutTransactionSetResponse;
import be.fgov.ehealth.hubservices.core.v3.SelectGetPatientAuditTrailType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class WalkThroughOrgPharmacyVitalinkIntegrationTest {

    @ClassRule
    public static TestRule sessionPrerequisite = BusinessSessionRule.withActiveSession("/be.ehealth.businessconnector.intrahubv3.test.orgpharmacy.properties");

    @ClassRule
    public static InitHubRule hubPrerequesite = new InitVitalinkHubRule();

    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    /**
     * SL for medication scheme transaction identification (platform-dependant)
     */
    private static final String TRANSACTION_URI = "vitalinkuri";
    
    private static int latestMedicationSchemeVersion;

    private final HubService hubService = hubPrerequesite.getHubService();

    private HubTestHelper helper = new HubTestHelper("vitalink/orgpharmacy", new Patient.Builder().withFirstName(HubConfigVitalink.PATIENT_FIRSTNAME).withFamilyName(HubConfigVitalink.PATIENT_LASTNAME).withInss(HubConfigVitalink.PATIENT_NISS).build());

    
   

    @Test
    public void _010_getTransactionList() throws Exception {
        PatientIdType patientId = helper.createPatientIdType();
        GetTransactionListResponse transactionListResponse = hubService.getTransactionList(patientId, LocalSearchType.GLOBAL, helper.createMedicationSchemeSearchTransaction());

        List<ErrorType> errors = transactionListResponse.getAcknowledge().getErrors();
        assertTrue("There should be one error element", errors.size() == 1);
        assertEquals("The status code should be 200(success)", "200", errors.get(0).getCds().get(0).getValue());
        assertTrue("Transaction list should not be empty", transactionListResponse.getKmehrheader().getFolder().getTransactions().size() > 0);
    }
    

    @Test
    public void _020_getLastestUpdate() throws Exception {
        GetLatestUpdateResponse latestUpdateResponse = hubService.getLatestUpdate(helper.createSelectGetLatestUpdateType());
        latestMedicationSchemeVersion = helper.getLatestMedicationSchemeVersion(latestUpdateResponse);
        
        XmlAsserter.assertSimilar(helper.expectedResponse("GetLatestUpdate"), ConnectorXmlUtils.toString(latestUpdateResponse));
    }

    @Test
    public void _030_putTransactionSet() throws Exception {
        Kmehrmessage kmehrmessage = helper.createTransactionSetMessage(latestMedicationSchemeVersion);
        
        PutTransactionSetResponse putTransactionSet = hubService.putTransactionSet(kmehrmessage);

        XmlAsserter.assertSimilar(helper.expectedResponse("PutTransactionSet"), ConnectorXmlUtils.toString(putTransactionSet));
    }

    @Test
    public void _040_getTransactionSet() throws Exception {
        PatientIdType patientId = helper.createPatientIdType();
        StringBuilder transactionSetIdBuilder = new StringBuilder()
                .append("/subject/")
                .append(HubConfigVitalink.PATIENT_NISS)
                .append("/medication-scheme");
        
        GetTransactionSetResponse transactionResponse = hubService.getTransactionSet(patientId, helper.createTransactionBaseType(TRANSACTION_URI, transactionSetIdBuilder.toString()));

        XmlAsserter.assertSimilar(helper.expectedResponse("GetTransactionSet"), ConnectorXmlUtils.toString(transactionResponse));
    }
    
    @Test
    public void _050_getPatientAuditTrail() throws Exception {
        SelectGetPatientAuditTrailType patientAudiTrail = new SelectGetPatientAuditTrailType();
        patientAudiTrail.setBegindate(new DateTime());
        patientAudiTrail.setEnddate(new DateTime());
        patientAudiTrail.setPatient(helper.createPatientIdType());
        GetPatientAuditTrailResponse getPatientAuditTrailResponse = hubService.getPatientAuditTrail(patientAudiTrail);

        assertEquals("Role [pharmacist] should not be allowed to perform action", "367", getPatientAuditTrailResponse.getAcknowledge().getErrors().get(0).getCds().get(0).getValue());
    }
    
}
