/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl.strategy;

import be.ehealth.technicalconnector.ws.impl.strategy.CacheBasedInvokeStrategy;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import be.ehealth.technicalconnector.ws.impl.strategy.NoRetryInvokeStrategy;
import be.ehealth.technicalconnector.ws.impl.strategy.RetryStrategy;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class InvokeStrategyFactory {
    private static EndpointDistributor distributor = EndpointDistributor.getInstance();

    public static final List<InvokeStrategy> getList(String endpoint) {
        ArrayList<InvokeStrategy> strategies = new ArrayList<InvokeStrategy>();
        String serviceName = distributor.getService(endpoint);
        CacheInformation cacheInformation = distributor.getCacheInformation(endpoint);
        int alternatives = distributor.getAmountOfAlternatives(endpoint);
        if (StringUtils.isBlank((String)serviceName) || alternatives == 1) {
            strategies.add(new NoRetryInvokeStrategy());
        } else if (alternatives > 1) {
            strategies.add(new RetryStrategy());
        }
        if (cacheInformation != null && cacheInformation.isActivated()) {
            strategies.add(new CacheBasedInvokeStrategy(cacheInformation));
        }
        return strategies;
    }
}

