/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl;

import be.ehealth.technicalconnector.exception.RetryNextEndpointException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.impl.SOAPMessageContextImpl;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategyContext;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategyFactory;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWsSender {
    public static final String MESSAGECONTEXT_ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";
    @Deprecated
    public static final String PROP_RETRY_STRATEGY = "be.ehealth.technicalconnector.ws.genericsender.invokestrategy";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWsSender.class);
    private static MessageFactory mf;
    private static SOAPConnectionFactory scf;

    public GenericResponse send(GenericRequest genericRequest) throws TechnicalConnectorException {
        List<InvokeStrategy> strategies = InvokeStrategyFactory.getList((String)genericRequest.getRequestMap().get(MESSAGECONTEXT_ENDPOINT_ADDRESS));
        InvokeStrategyContext ctx = new InvokeStrategyContext(genericRequest);
        for (InvokeStrategy strategy : strategies) {
            LOG.debug("Using invoke strategy [" + strategy.getClass() + "]");
            if (!strategy.invoke(ctx)) continue;
            break;
        }
        if (ctx.hasException()) {
            throw ctx.getException();
        }
        return ctx.getResponse();
    }

    protected GenericResponse call(GenericRequest genericRequest) throws TechnicalConnectorException {
        GenericResponse genericResponse;
        SOAPConnection conn = null;
        Object[] chain = genericRequest.getHandlerchain();
        try {
            SOAPMessageContext request = this.createSOAPMessageCtx(genericRequest);
            request.putAll(genericRequest.getRequestMap());
            request.put((Object)"javax.xml.ws.handler.message.outbound", (Object)true);
            AbstractWsSender.executeHandlers(chain, request);
            conn = scf.createConnection();
            SOAPMessageContext reply = AbstractWsSender.createSOAPMessageCtx(conn.call(request.getMessage(), (Object)AbstractWsSender.generateEndpoint(request)));
            reply.putAll(genericRequest.getRequestMap());
            reply.put((Object)"javax.xml.ws.handler.message.outbound", (Object)false);
            ArrayUtils.reverse((Object[])chain);
            AbstractWsSender.executeHandlers((Handler[])chain, reply);
            genericResponse = new GenericResponse(reply.getMessage());
        }
        catch (Exception e) {
            try {
                throw AbstractWsSender.translate(e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)conn);
        return genericResponse;
    }

    private static SOAPMessageContext createSOAPMessageCtx(SOAPMessage msg) {
        return new SOAPMessageContextImpl(msg);
    }

    private static TechnicalConnectorException translate(Exception e) {
        if (e instanceof SOAPException) {
            return new RetryNextEndpointException(e);
        }
        if (e instanceof TechnicalConnectorException) {
            return (TechnicalConnectorException)e;
        }
        Throwable reason = ExceptionUtils.getRootCause((Throwable)e);
        LOG.error("Cannot send SOAP message. Reason [" + reason + "]", (Throwable)e);
        return new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, reason, "Cannot send SOAP message");
    }

    private static void executeHandlers(Handler[] handlers, SOAPMessageContext ctx) throws TechnicalConnectorException {
        for (Handler handler : handlers) {
            if (handler.handleMessage((MessageContext)ctx)) continue;
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_WS;
            LOG.error(MessageFormat.format(errorValue.getMessage(), "Error while executing handler " + handler.getClass()));
            throw new TechnicalConnectorException(errorValue, "Error while executing handler.");
        }
    }

    protected String getCurrentEndpoint(GenericRequest genericRequest) {
        return (String)genericRequest.getRequestMap().get(MESSAGECONTEXT_ENDPOINT_ADDRESS);
    }

    private static URL generateEndpoint(final SOAPMessageContext request) throws MalformedURLException {
        String requestedTarget = (String)request.get((Object)MESSAGECONTEXT_ENDPOINT_ADDRESS);
        String target = EndpointDistributor.getInstance().getActiveEndpoint(requestedTarget);
        request.put((Object)MESSAGECONTEXT_ENDPOINT_ADDRESS, (Object)target);
        URL targetURL = new URL(target);
        StringBuffer context = new StringBuffer();
        context.append(targetURL.getProtocol());
        context.append("://");
        context.append(targetURL.getHost());
        if (targetURL.getPort() != -1) {
            context.append(":");
            context.append(targetURL.getPort());
        }
        URL endpoint = new URL(new URL(context.toString()), targetURL.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                URL target = new URL(url.toString());
                URLConnection connection = target.openConnection();
                connection.setConnectTimeout(Integer.parseInt((String)request.get((Object)"connector.soaphandler.connection.connection.timeout")));
                connection.setReadTimeout(Integer.parseInt((String)request.get((Object)"connector.soaphandler.connection.request.timeout")));
                return connection;
            }
        });
        return endpoint;
    }

    protected SOAPMessageContext createSOAPMessageCtx(GenericRequest genericRequest) throws TechnicalConnectorException {
        try {
            SOAPMessage soapMessage = mf.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            if (genericRequest.isXopEnabled()) {
                soapMessage.getMimeHeaders().addHeader("Content-Type", "application/xop+xml");
                soapPart.addMimeHeader("Content-ID", "<root.message@ehealth.fgov.be>");
                soapPart.addMimeHeader("Content-Transfer-Encoding", "8bit");
            }
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            soapBody.addDocument(genericRequest.getPayload());
            Map<String, DataHandler> handlers = genericRequest.getDataHandlerMap();
            for (Map.Entry<String, DataHandler> handlerEntry : handlers.entrySet()) {
                DataHandler handler = handlerEntry.getValue();
                AttachmentPart part = soapMessage.createAttachmentPart(handler);
                part.setContentType(handler.getContentType());
                if (genericRequest.isXopEnabled()) {
                    part.addMimeHeader("Content-Transfer-Encoding", "binary");
                    part.setContentId("<" + handlerEntry.getKey() + ">");
                } else {
                    part.setContentId(handlerEntry.getKey());
                }
                soapMessage.addAttachmentPart(part);
            }
            return AbstractWsSender.createSOAPMessageCtx(soapMessage);
        }
        catch (SOAPException e) {
            throw AbstractWsSender.translate((Exception)((Object)e));
        }
    }

    static {
        try {
            mf = MessageFactory.newInstance();
            scf = SOAPConnectionFactory.newInstance();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SOAPException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

