/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingHandler.class);
    static final String MESSAGE_ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        if (msg != null && LOG.isInfoEnabled()) {
            String endPoint = (String)context.get((Object)MESSAGE_ENDPOINT_ADDRESS);
            String soapAction = ArrayUtils.toString((Object)msg.getMimeHeaders().getHeader("SOAPAction"));
            LOG.info("Invoking webservice on url: [" + endPoint + "] with SOAPAction(s) " + soapAction);
            msg.getMimeHeaders().getHeader("X-CorrelationID");
        }
        if (LOG.isDebugEnabled()) {
            LoggingHandler.dumpMessage(msg, "OUT", LOG);
        }
        return true;
    }

    @Override
    public boolean handleInbound(SOAPMessageContext context) {
        Object[] correlationIDs;
        SOAPMessage msg = context.getMessage();
        if (LOG.isInfoEnabled() && ArrayUtils.isNotEmpty((Object[])(correlationIDs = msg.getMimeHeaders().getHeader("X-CorrelationID")))) {
            LOG.info("Retrieved response with X-CorrelationID [{}]", (Object)StringUtils.join((Object[])correlationIDs));
        }
        if (LOG.isDebugEnabled()) {
            LoggingHandler.dumpMessage(msg, "IN", LOG);
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext c) {
        this.handleMessage(c);
        return true;
    }
}

