/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.signature.domain;

import java.util.concurrent.TimeUnit;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.service.timestamp.TimestampUtil;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;


/**
 * Class to verify the {@link SignatureVerificationResult}
 * 
 * @author EHP
 */
public class SignatureVerificationResultTest {

    private static final DateTime signingTime = new DateTime().minusDays(5);

    @BeforeClass
    public static void init() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void isSerializable() throws Exception {
        SignatureVerificationResult expected = new SignatureVerificationResult();
        byte[] tsToken = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/examples/tstoken.base64")).getBytes();
        expected.getTsTokens().add(TimestampUtil.getTimestamp(ConnectorIOUtils.base64Decode(tsToken, false)));
        AssertTools.assertSerializable(expected, true);

    }

    @Test
    public void timestampBeforeSigningTimeWithinTollerance() throws Exception {
        SignatureVerificationResult result = new SignatureVerificationResult();
        result.setSigningTime(signingTime);
        result.getTimestampGenTimes().add(signingTime.minusMinutes(3));
        DateTime verifiedSigningTime = result.getVerifiedSigningTime(5, TimeUnit.MINUTES);
        Assert.assertTrue(verifiedSigningTime.isEqual(signingTime));
    }

    @Test
    public void timestampAfterSigningTimeWithinTollerance() throws Exception {
        SignatureVerificationResult result = new SignatureVerificationResult();
        result.setSigningTime(signingTime);
        result.getTimestampGenTimes().add(signingTime.plusMinutes(3));
        DateTime verifiedSigningTime = result.getVerifiedSigningTime(5, TimeUnit.MINUTES);
        Assert.assertTrue(verifiedSigningTime.isEqual(signingTime));
    }

    @Test
    public void timestampBeforeSigningTimeNotInTollerance() throws Exception {
        SignatureVerificationResult result = new SignatureVerificationResult();
        result.setSigningTime(signingTime);
        result.getTimestampGenTimes().add(signingTime.minusMinutes(10));
        DateTime verifiedSigningTime = result.getVerifiedSigningTime(5, TimeUnit.MINUTES);
        Assert.assertFalse(verifiedSigningTime.isEqual(signingTime));
    }

    @Test
    public void timestampAfterSigningTimeNotInTollerance() throws Exception {
        SignatureVerificationResult result = new SignatureVerificationResult();
        result.setSigningTime(signingTime);
        result.getTimestampGenTimes().add(signingTime.plusMinutes(10));
        DateTime verifiedSigningTime = result.getVerifiedSigningTime(5, TimeUnit.MINUTES);
        Assert.assertFalse(verifiedSigningTime.isEqual(signingTime));
    }


}
