/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genins.builders;

import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.genins.exception.GenInsBusinessConnectorException;
import be.ehealth.businessconnector.genins.mapper.CommonInputMapper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.genericinsurability.core.v1.CommonInputType;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;

/**
 * TDJIR EHCON-349: Description of the class.
 * 
 * @author EHP
 */
public class CommonBuilderFactoryTest {

    @BeforeClass
    public static void initConfig() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.genins.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void testCreateCommonInput() throws TechnicalConnectorException, GenInsBusinessConnectorException, InstantiationException, JAXBException, TransformerConfigurationException, TransformerFactoryConfigurationError {
        CommonInput commonInput = RequestBuilderFactory.getCommonBuilder("genins").createCommonInput(McnConfigUtil.retrievePackageInfo("genins"), false, IdGeneratorFactory.getIdGenerator().generateId());
        Nihii nihii = new Nihii("persphysician", SessionUtil.getNihii11());
        commonInput.getOrigin().getCareProvider().getPhysicalPerson().setNihii(nihii);
        CommonInputType requestObjectBuilder = CommonInputMapper.mapCommonInput(commonInput);
        Assert.assertNotNull(requestObjectBuilder);
        Assert.assertNotNull(requestObjectBuilder.getOrigin());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getPackage());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getPackage().getLicense());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getPackage().getName());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getNihii());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getNihii());
        // Assert.assertEquals("doctor", requestObjectBuilder.getOrigin().getCareProvider().getNihii().getQuality());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getPhysicalPerson());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getPhysicalPerson().getNihii());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getPhysicalPerson().getName());
        Assert.assertNotNull(requestObjectBuilder.getOrigin().getCareProvider().getPhysicalPerson().getSsin());
        // Assert.assertEquals("doctor", requestObjectBuilder.getOrigin().getCareProvider().getPhysicalPerson().getNihii().getQuality());
        Assert.assertNotNull(requestObjectBuilder.getInputReference());

    }


}
