/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehbox.v3.testcases;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehbox.v3.EhboxTestDataBuilder;
import be.ehealth.businessconnector.ehbox.v3.EhboxTestUtilities;
import be.ehealth.businessconnector.ehbox.v3.MessageBuilder;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageRequest;


/**
 * @author eh062
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class SendingEncryptedMessageToUnknownPartyIntegrationTest {

    private static final String MESSAGE_TITLE = "Scenario 3";

    private static final String MESSAGE_CONTENT = "message test connector scenario 3";

    private static final String MESSAGE_DESTINATION_ID = "56035613";

    private static final String EXPECTED_ERROR_MESSAGE = "Could not retrieve ETK";

    /*************************************/
    /*                                   */
    /* JUNIT METHODS */
    /*                                   */
    /*************************************/

    @BeforeClass
    public static void checkSenderIsDoctor() throws TechnicalConnectorException {
        Assume.assumeTrue(EhboxTestUtilities.isDoctorTest());
    }

    @BeforeClass
    public static void setUp() throws Exception {
        EhboxTestUtilities.createSession();
    }

    @AfterClass
    public static void tearDown() {
        EhboxTestUtilities.destroySession();
    }

    /*************************************/
    /*                                   */
    /* TEST METHODS */
    /*                                   */
    /*************************************/

    private SendMessageRequest prepareAndVerifySendMessageRequest(DocumentMessage<Message> message) throws Exception {
        SendMessageRequest request = EhboxTestUtilities.prepareSendRequest(message);

        Assert.assertFalse("There should not be a receipt on the publication set", request.getContentContext().getContentSpecification().isPublicationReceipt());
        Assert.assertFalse("There should not be a receipt on the read set", request.getContentContext().getContentSpecification().isReadReceipt());
        Assert.assertFalse("There should not be a receipt on the reception set", request.getContentContext().getContentSpecification().isReceivedReceipt());

        return request;
    }

    @Test
    public void testStep1SendEncryptedMessageToUnknownParty() throws Exception {
        MessageBuilder builder = MessageBuilder.create(EhboxTestDataBuilder.generateDestination(MESSAGE_DESTINATION_ID, IdentifierType.NIHII_LABO, QualityType.LABO_NIHII), MESSAGE_CONTENT).title(MESSAGE_TITLE).encrypted(true);
        DocumentMessage<Message> message = EhboxTestDataBuilder.generateDocumentMessage(builder);

        try {
            EhboxTestUtilities.sendMessage(this.prepareAndVerifySendMessageRequest(message));
        } catch (TechnicalConnectorException tce) {
            Assert.assertEquals(EXPECTED_ERROR_MESSAGE, tce.getMessage());
        }
    }

}
