/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;


/**
 * Test class for {@link CertificateParser}
 * 
 * @author EHP
 */
public class CertificateParserTest {

    @BeforeClass
    public static void before() throws Exception {
        LoggingUtils.bootstrap();
    }

    @Test
    public void ehealthCertificate() throws Exception {
        String subject = "O=Federal Government, OU=eHealth-platform Belgium, OU=EHEALTH-PLATFORM, OU=\"CBE=0809394427\", OU=TTP, C=BE, CN=\"CBE=0809394427, TTP\"";

        CertificateParser parser = new CertificateParser(subject);
        Assert.assertEquals("TTP", parser.getApplication());
        Assert.assertEquals("CBE", parser.getType());
        Assert.assertEquals("0809394427", parser.getId());
        Assert.assertEquals(IdentifierType.CBE, parser.getIdentifier());
    }

    @Test
    public void eIDertificate() throws Exception {

        String subject = "2.5.4.5=#130b3832303531323334393738,2.5.4.42=#130b48616e6e65732048616e73,2.5.4.4=#1309446520436c65726371,CN=Hannes De Clercq (Authentication),C=BE";

        CertificateParser parser = new CertificateParser(subject);
        Assert.assertEquals("", parser.getApplication());
        Assert.assertEquals("SSIN", parser.getType());
        Assert.assertEquals("82051234978", parser.getId());
        Assert.assertEquals(IdentifierType.SSIN, parser.getIdentifier());
    }


    @Test
    public void currentEid() throws Exception {
        AssumeTools.isEIDEnabled();
        BeIDCredential cred = BeIDCredential.getInstance("", BeIDCredential.EID_SIGN_ALIAS);
        CertificateParser parser = new CertificateParser(cred.getCertificate());
        Assert.assertEquals(BeIDInfo.getInstance().getIdentity().getNationalNumber(), parser.getId());
        Assert.assertEquals(IdentifierType.SSIN, parser.getIdentifier());
    }


}
