/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.builders;

import org.junit.Assert;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.hubservices.core.v1.AccessRightType;
import be.fgov.ehealth.hubservices.core.v1.ConsentHCPartyType;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.HCPartyAdaptedType;
import be.fgov.ehealth.hubservices.core.v1.HCPartyIdType;
import be.fgov.ehealth.hubservices.core.v1.KmehrHeaderDeclareTransaction;
import be.fgov.ehealth.hubservices.core.v1.LocalSearchType;
import be.fgov.ehealth.hubservices.core.v1.PatientIdType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetHCPartyPatientConsentType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetPatientAuditTrailType;
import be.fgov.ehealth.hubservices.core.v1.SelectGetPatientConsentType;
import be.fgov.ehealth.hubservices.core.v1.SelectRevokeAccessRightType;
import be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType;
import be.fgov.ehealth.hubservices.core.v1.TransactionBaseType;
import be.fgov.ehealth.hubservices.core.v1.TransactionIdType;
import be.fgov.ehealth.hubservices.core.v1.TransactionWithPeriodType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.standards.kmehr.schema.v1.PersonType;


/**
 * Test case for {@link RequestBuilder}.
 * 
 * @author EHP
 * 
 */
public class RequestBuilderTest {

    /**
     * Instance of the tested class
     */
    private RequestBuilder builder = new RequestBuilder();


    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildKmehrHeaderDeclareTransaction(java.lang.String)}
     * 
     * @throws Exception
     */
    @Test
    public void testBuildKmehrHeaderDeclareTransaction() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/khmerheader.xml"));
        KmehrHeaderDeclareTransaction actual = builder.buildKmehrHeaderDeclareTransaction(xml);
        KmehrHeaderDeclareTransaction expected = TestObjectBuilder.getKmehrHeaderDeclareTransaction();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildKmehrmessage(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildKmehrmessage() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/khmermessage.xml"));
        Kmehrmessage actual = builder.buildKmehrmessage(xml);
        Kmehrmessage expected = TestObjectBuilder.getKmehrmessage();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildPatientIdType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildPatientIdType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/patientidtype.xml"));

        PatientIdType actual = builder.buildPatientIdType(xml);
        PatientIdType expected = TestObjectBuilder.getPatientIdType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildTransactionIdType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTransactionIdType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/transactionidtype.xml"));

        TransactionIdType actual = builder.buildTransactionIdType(xml);
        TransactionIdType expected = TestObjectBuilder.getTransactionIdType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildLocalSearchType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildLocalSearchType() throws Exception {
        String name = "global";
        LocalSearchType actual = builder.buildLocalSearchType(name);
        LocalSearchType expected = LocalSearchType.GLOBAL;
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildTransactionWithPeriodType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTransactionWithPeriodType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/transactionwithperiodtype.xml"));
        TransactionWithPeriodType actual = builder.buildTransactionWithPeriodType(xml);
        TransactionWithPeriodType expected = TestObjectBuilder.getTransactionWithPeriodType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildTransactionBaseType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTransactionBaseType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/transactionbasetype.xml"));

        TransactionBaseType actual = builder.buildTransactionBaseType(xml);
        TransactionBaseType expected = TestObjectBuilder.getTransactionBaseType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildHCPartyAdaptedType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildHCPartyAdaptedType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/hcpartyadaptedtype.xml"));

        HCPartyAdaptedType actual = builder.buildHCPartyAdaptedType(xml);
        HCPartyAdaptedType expected = TestObjectBuilder.getHCPartyAdaptedType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildHCPartyIdType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildHCPartyIdType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/hcpartyidtype.xml"));

        HCPartyIdType actual = builder.buildHCPartyIdType(xml);
        HCPartyIdType expected = TestObjectBuilder.getHCPartyIdType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildPersonType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildPersonType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/persontype.xml"));

        PersonType actual = builder.buildPersonType(xml);
        PersonType expected = TestObjectBuilder.getPersonTypeFull();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildConsentHCPartyType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildConsentHCPartyType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/consenthcpartytype.xml"));

        ConsentHCPartyType actual = builder.buildConsentHCPartyType(xml);
        ConsentHCPartyType expected = TestObjectBuilder.getConsentHCPartyType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildConsentType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildConsentType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/consenttype.xml"));

        ConsentType actual = builder.buildConsentType(xml);
        ConsentType expected = TestObjectBuilder.getConsentType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildSelectGetPatientConsentType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildSelectGetPatientConsentType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/selectgetpatientconsenttype.xml"));

        SelectGetPatientConsentType actual = builder.buildSelectGetPatientConsentType(xml);
        SelectGetPatientConsentType expected = TestObjectBuilder.getSelectGetPatientConsentType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildTherapeuticLinkType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildTherapeuticLinkType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/therapeuticlinktype.xml"));

        TherapeuticLinkType actual = builder.buildTherapeuticLinkType(xml);
        TherapeuticLinkType expected = TestObjectBuilder.getTherapeuticLinkType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildSelectGetHCPartyPatientConsentType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildSelectGetHCPartyPatientConsentType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/selectgethcpartypatientconsenttype.xml"));

        SelectGetHCPartyPatientConsentType actual = builder.buildSelectGetHCPartyPatientConsentType(xml);
        SelectGetHCPartyPatientConsentType expected = TestObjectBuilder.getSelectGetHCPartyPatientConsentType();
        Assert.assertNotNull(actual);

        ReflectionAssert.assertLenientEquals(expected, actual);
    }


    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildAccessRightType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildAccessRightType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/accessrighttype.xml"));

        AccessRightType actual = builder.buildAccessRightType(xml);
        AccessRightType expected = TestObjectBuilder.getAccessRightType();

        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildSelectRevokeAccessRightType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildSelectRevokeAccessRightType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/selectrevokeaccessrighttype.xml"));

        SelectRevokeAccessRightType actual = builder.buildSelectRevokeAccessRightType(xml);
        SelectRevokeAccessRightType expected = TestObjectBuilder.getSelectRevokeAccessRightType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.hub.builders.RequestBuilder#buildSelectGetPatientAuditTrailType(java.lang.String)}.
     * 
     * @throws Exception
     */
    @Test
    public void testBuildSelectGetPatientAuditTrailType() throws Exception {
        String xml = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/requests/selectgetpatientaudittrailtype.xml"));

        SelectGetPatientAuditTrailType actual = builder.buildSelectGetPatientAuditTrailType(xml);
        SelectGetPatientAuditTrailType expected = TestObjectBuilder.getSelectGetPatientAuditTrailType();
        ReflectionAssert.assertReflectionEquals(expected, actual, ReflectionComparatorMode.LENIENT_ORDER);
    }

}
