package be.ehealth.businessconnector.genericasync.helper;

import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.PostResponse;
import be.ehealth.business.mycarenetcommons.builders.util.BlobUtil;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.async.PostContent;
import be.ehealth.business.mycarenetdomaincommons.util.WsAddressingUtil;
import be.ehealth.businessconnector.genericasync.builders.BuilderFactory;
import be.ehealth.businessconnector.genericasync.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.businessconnector.genericasync.session.GenAsyncService;
import be.ehealth.businessconnector.genericasync.session.GenAsyncSessionServiceFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.domain.WsAddressingHeader;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static be.ehealth.businessconnector.genericasync.domain.GenericAsyncConstants.POST_SOAP_ACTION;

/**
 * @author EHP
 */
public class PostTestHelper {

    private final Logger LOG = LoggerFactory.getLogger(PostTestHelper.class);

    private String projectName;

    private String oa;
    
    private boolean test;
    
    private boolean withXades;

    private PostTestHelper(Builder builder) {
        projectName = builder.projectName;
        oa = builder.oa;
        test = builder.test;
        withXades = builder.withXades;
    }

    public static Builder Builder() {
        return new Builder();
    }


    public void validateResponse(PostResponse responsePost) throws GenAsyncBusinessConnectorException, TechnicalConnectorException, InstantiationException {
        ConnectorXmlUtils.dump(responsePost);
        ResponseObjectBuilder responseBuilder = BuilderFactory.getResponseObjectBuilder();
        responseBuilder.handlePostResponse(responsePost);
    }

    public PostResponse post(String serviceName, Post post) throws ConnectorException {
        GenAsyncService service = GenAsyncSessionServiceFactory.getGenAsyncService(serviceName);
        WsAddressingHeader header = WsAddressingUtil.createHeader(oa, POST_SOAP_ACTION);
        return service.postRequest(post, header);
    }

    public Post buildPostRequest(byte[] contentBytes, String messageName) throws TechnicalConnectorException, GenAsyncBusinessConnectorException, InstantiationException {
        BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder(projectName);
        Blob blob = blobBuilder.build(contentBytes);
        blob.setMessageName(messageName);
        String commonInputReference = IdGeneratorFactory.getIdGenerator().generateId();
        byte[] xades = null;
        if (withXades) {
            xades = BlobUtil.generateXades(blob, projectName);
        }
        
        PostContent postContent = PostContent.Builder()
                .blob(blob)
                .commonInputReference(commonInputReference)
                .isTest(test)
                .messageName(messageName)
                .xades(xades)
                .build();
        
        return BuilderFactory.getRequestObjectBuilder(projectName).buildPostRequest(projectName, postContent);
    }

    public static final class Builder {
        private String projectName;
        private String oa;
        private boolean test = true;
        private boolean withXades;

        private Builder() {
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder oa(String oa) {
            this.oa = oa;
            return this;
        }

        public Builder isTest(boolean test) {
            this.test = test;
            return this;
        }

        public Builder withXades(boolean withXades) {
            this.withXades = withXades;
            return this;
        }

        public PostTestHelper build() {
            return new PostTestHelper(this);
        }
    }
}
