package be.ehealth.businessconnector.ehbox.v3.session;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehbox.v3.builders.BuilderFactory;
import be.ehealth.businessconnector.ehbox.v3.builders.ConsultationMessageBuilder;
import be.ehealth.businessconnector.ehbox.v3.builders.RequestBuilder;
import be.ehealth.businessconnector.ehbox.v3.builders.SendMessageBuilder;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.ConsultationAnnexType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetMessagesListResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class EhboxV3ServiceIntegrationTest {

    static {
        System.setProperty("javax.net.debug", "none");
    }

    @ClassRule
    public static TestRule chain = SessionRule.withActiveSession().forEnvironment("int").forProfession("persphysician").forUser("hannes").build();


    private static SendMessageBuilder messageBuilder;
    private static RequestBuilder requestBuilder;
    private static ConsultationMessageBuilder consultBuilder;
    private static EhealthBoxServiceV3 service;

    private String messageId;

    @BeforeClass
    public static void initSession() throws Exception {
        messageBuilder = BuilderFactory.getSendMessageBuilder();
        requestBuilder = BuilderFactory.getRequestBuilder();
        consultBuilder = BuilderFactory.getConsultationMessageBuilder();
        service = ServiceFactory.getEhealthBoxServiceV3();
    }


    @Test
    public void _00_sendMessage() throws Exception {

        DocumentMessage msg = new DocumentMessage();

        Addressee addressee = new Addressee("82051234978", QualityType.DOCTOR_SSIN);
        msg.getDestinations().add(addressee);

        Document doc = new Document();
        doc.setTitle("body");
        doc.setContent("body-eureka".getBytes());
        doc.setMimeType("application/octet-stream");
        doc.setFilename("body.dump");
        msg.setDocument(doc);

        Document annex = new Document();
        annex.setTitle("annex");
        annex.setContent("annex-eureka".getBytes());
        annex.setMimeType("application/octet-stream");
        annex.setFilename("annex.dump");
        msg.getAnnexList().add(annex);

        msg.setEncrypted(true);

        SendMessageRequest request = messageBuilder.buildMessage(msg);
        SendMessageResponse response = service.sendMessage(request);
        messageId = response.getId();
    }

    @Test
    public void _01_getMessageList() throws Exception {

        GetMessagesListRequest request = requestBuilder.createGetMessagesListRequest("INBOX");

        GetMessagesListResponse messageList = service.getMessageList(request);

        if (messageId != null) {
            boolean found = false;
            for (Message message : messageList.getMessages()) {
                if (message.getMessageId().equals(messageId)) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                Assert.fail("Required messageId not found");
            }
        }
    }

    @Test
    public void _02_getMessage() throws Exception {

        GetFullMessageRequest requestFullMessage = new GetFullMessageRequest();
        requestFullMessage.setSource("INBOX");
        requestFullMessage.setMessageId(messageId);

        GetFullMessageResponse responseFullMessage = service.getFullMessage(requestFullMessage);
        be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage<GetFullMessageResponse> message = (DocumentMessage<GetFullMessageResponse>) consultBuilder.buildFullMessage(responseFullMessage);

        for (ConsultationAnnexType annex : message.getOriginal().getMessage().getContentContext().getContent().getAnnices()) {
            if (ArrayUtils.isEmpty(annex.getEncryptableTextContent()) && annex.getEncryptableBinaryContent() == null) {
                throw new IllegalArgumentException("Empty Annex");
            }
        }
        System.out.println(new String(message.getAnnexList().get(0).getContent()));


    }
}
