/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hubv3.security;

import be.ehealth.businessconnector.hubv3.util.RequestTypeBuilder;
import be.ehealth.businessconnector.testcommons.BusinessSessionRule;
import be.fgov.ehealth.hubservices.core.v3.RequestType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

import javax.xml.bind.JAXB;
import java.util.List;


/**
 * Integration tests for encrypted requests.
 * 
 * @author EHP
 */
public class HubRequestWithEncryptionIntegrationTest {

    @ClassRule
    public static TestRule sessionPrerequisite = BusinessSessionRule.withActiveSession("/be.ehealth.businessconnector.intrahubv3.test.properties");


    @Test
    public void testRequestBuilder() throws Exception {
        RequestType req = RequestTypeBuilder.init().addAuthorWithEncryptionInformation().build();
        List<HcpartyType> partiesList = req.getAuthor().getHcparties();
        boolean containsEncryption = false;
        for (HcpartyType hcpartyType : partiesList) {
            if (hcpartyType.getFirstname() != null) {
                for (IDHCPARTY hcparty : hcpartyType.getIds()) {
                    if (hcparty.getS().compareTo(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR) == 0) {
                        containsEncryption = true;
                    }
                }
            }
        }
        Assert.assertTrue(containsEncryption);

        JAXB.marshal(req, System.out);
    }
}
