/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public final class IoUtils {
    private static final Logger LOGGER = Logger.getLogger(IoUtils.class);

    private IoUtils() {
    }

    public static File writeToFile(byte[] data, String pathname) {
        File file = new File(pathname);
        LOGGER.info((Object)("Writing data to file " + file.getAbsolutePath()));
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid data or path. Unable to write data to " + pathname, e);
        }
        return file;
    }

    public static byte[] readFile(String pathname) {
        FileInputStream is = IoUtils.openFileInputStream(pathname);
        return Streams.getBytes(is);
    }

    public static FileInputStream openFileInputStream(String pathname) {
        FileInputStream fis;
        File file = new File(pathname);
        LOGGER.info((Object)("Opening FileInputStream at " + file.getAbsolutePath()));
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid path. Unable to open input stream.", e);
        }
        return fis;
    }

    public static FileOutputStream openFileOutputStream(String pathname) {
        FileOutputStream fos;
        File file = new File(pathname);
        LOGGER.info((Object)("Opening FileOutputStream at " + file.getAbsolutePath()));
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid path. Unable to open output stream.", e);
        }
        return fos;
    }
}

