/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.CmsEncrypter;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealerException;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.encrypt.MessageSigner;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.bouncycastle.cms.CMSException;

final class TripleWrapper
implements DataSealer {
    private static final Logger LOGGER = Logger.getLogger(TripleWrapper.class);
    private final CmsEncrypter cmsEncryptor;
    private final MessageSigner messageSigner;

    TripleWrapper(CmsEncrypter cmsEncryptor, MessageSigner messageSigner) {
        this.cmsEncryptor = cmsEncryptor;
        this.messageSigner = messageSigner;
    }

    @Override
    public byte[] seal(EncryptionToken etk, byte[] dataToEncrypt) throws DataSealerException {
        return this.wrap(this.getEncryptionTokens(etk), dataToEncrypt, null, null);
    }

    @Override
    public byte[] seal(Set<EncryptionToken> etks, byte[] dataToEncrypt) throws DataSealerException {
        return this.wrap(etks, dataToEncrypt, null, null);
    }

    @Override
    public byte[] seal(EncryptionToken etk, byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        return this.wrap(this.getEncryptionTokens(etk), dataToSeal, kek, base64encodeKekId);
    }

    @Override
    public byte[] seal(Set<EncryptionToken> etks, byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        return this.wrap(etks, dataToSeal, kek, base64encodeKekId);
    }

    @Override
    public byte[] seal(byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        return this.wrap(null, dataToSeal, kek, base64encodeKekId);
    }

    @Override
    public void seal(EncryptionToken etk, InputStream dataToSeal, OutputStream sealedData) throws DataSealerException {
        this.wrap(this.getEncryptionTokens(etk), dataToSeal, sealedData, null, null);
    }

    @Override
    public void seal(Set<EncryptionToken> etks, InputStream dataToSeal, OutputStream sealedData) throws DataSealerException {
        this.wrap(etks, dataToSeal, sealedData, null, null);
    }

    @Override
    public void seal(EncryptionToken etk, InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        this.wrap(this.getEncryptionTokens(etk), dataToSeal, sealedData, kek, base64encodeKekId);
    }

    @Override
    public void seal(Set<EncryptionToken> etks, InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        this.wrap(etks, dataToSeal, sealedData, kek, base64encodeKekId);
    }

    @Override
    public void seal(InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        this.wrap(null, dataToSeal, sealedData, kek, base64encodeKekId);
    }

    byte[] wrap(Set<EncryptionToken> etks, byte[] data, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        try {
            byte[] innerSignedData = this.messageSigner.signInnerData(data);
            LOGGER.debug((Object)"Creating EnvelopedData...");
            byte[] encryptedData = etks != null ? this.encryptWithAssymmetricKeys(etks, kek, base64encodeKekId, innerSignedData) : this.cmsEncryptor.encryptData(innerSignedData, kek, base64encodeKekId);
            return this.messageSigner.signOuterData(encryptedData);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.buildDataSealerException("Algorithm not available.", e);
        }
        catch (CertificateException e) {
            throw this.buildDataSealerException("Certificates could not be added.", e);
        }
        catch (OCSPException e) {
            throw this.buildDataSealerException("RevocationValues could not be generated.", e);
        }
        catch (Exception e) {
            throw this.buildDataSealerException("Data could not be sealed.", e);
        }
    }

    private byte[] encryptWithAssymmetricKeys(Set<EncryptionToken> etks, SecretKey kek, String base64encodeKekId, byte[] innerSignedData) throws CertificateEncodingException, IOException, CMSException {
        List<X509Certificate> encryptionCerts = this.getEncryptionCerts(etks);
        byte[] encryptedData = kek != null ? this.cmsEncryptor.encryptData(innerSignedData, encryptionCerts, kek, base64encodeKekId) : this.cmsEncryptor.encryptData(innerSignedData, encryptionCerts);
        return encryptedData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wrap(Set<EncryptionToken> etks, InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        OutputStream dataToBeSignedStream = null;
        OutputStream dataToEncrypt = null;
        OutputStream dataToWrap = null;
        try {
            dataToBeSignedStream = this.messageSigner.openOuterDataStream(sealedData);
            dataToEncrypt = this.cmsEncryptor.openDataToBeEncryptedStream(dataToBeSignedStream, this.getEncryptionCerts(etks), kek, base64encodeKekId);
            dataToWrap = this.messageSigner.openInnerDataStream(dataToEncrypt);
            Streams.copy(dataToSeal, dataToWrap);
        }
        catch (CertificateException e) {
            try {
                throw this.buildDataSealerException("Certificates could not be added.", e);
                catch (OCSPException e2) {
                    throw this.buildDataSealerException("RevocationValues could not be generated.", e2);
                }
                catch (Exception e3) {
                    throw this.buildDataSealerException("Data could not be sealed.", e3);
                }
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(dataToEncrypt);
                Streams.closeQuietly(dataToBeSignedStream);
                throw throwable;
            }
        }
        Streams.closeQuietly(dataToEncrypt);
        Streams.closeQuietly(dataToBeSignedStream);
    }

    private DataSealerException buildDataSealerException(String msg, Exception cause) {
        LOGGER.error((Object)msg, (Throwable)cause);
        return new DataSealerException(msg, cause);
    }

    private List<X509Certificate> getEncryptionCerts(Set<EncryptionToken> etks) {
        ArrayList<X509Certificate> encrCerts = new ArrayList<X509Certificate>();
        if (etks == null || etks.isEmpty()) {
            return encrCerts;
        }
        for (EncryptionToken etk : etks) {
            encrCerts.add(etk.getCertificate());
        }
        return encrCerts;
    }

    private Set<EncryptionToken> getEncryptionTokens(EncryptionToken etk) {
        HashSet<EncryptionToken> etks = new HashSet<EncryptionToken>();
        if (etk == null) {
            return etks;
        }
        etks.add(etk);
        return etks;
    }
}

