﻿/*
 * Copyright (c) eHealth
 */
using System;
using java.math;
using NUnit.Framework;

using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.session;
using be.ehealth.businessconnector.insurability.builders;
using be.ehealth.businessconnector.insurability.builders.impl;
using be.ehealth.businessconnector.insurability.domain;
using be.ehealth.businessconnector.insurability.session;
using be.ehealth.businessconnector.insurability.session.impl;
using be.fgov.ehealth.insurability.core.v1;
using be.fgov.ehealth.insurability.protocol.v1;
using org.unitils.reflectionassert;
using be.ehealth.technicalconnector.exception;



namespace be.ehealth.businessconnector.insurability.integration
{
	[TestFixture]
	public class InsurabilityIntegrationtest
	{
		[SetUp]
		public void init(){
			SessionInitializer.init("be.ehealth.businessconnector.insurability.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[TearDown]
		public void tearDown() {
			Session.getInstance().unloadSession();
		}
		
		[Test]
		public void testOA500(){
			generateTest("96022530604", null, null, "F", new org.joda.time.DateTime());
		}
		
		[Test]
		public void testOA100(){
			generateTest("82051234978", null, null, "F", new org.joda.time.DateTime());
		}
		
		private void generateTest(String ssin, String mutuality, String registNumber, String requestType, org.joda.time.DateTime requestDate){
			
			RequestObjectBuilder requestObjectBuilder = new RequestObjectBuilderImpl();
			GetInsurabilityForPharmacistRequest insurabilityRequest;
			
			InsurabilityReferences references = new InsurabilityReferences(true);
			InsurabilityForPharmacistRequest request = new InsurabilityForPharmacistRequest();
			CareReceiverIdType careReceiverId = new CareReceiverIdType();
			
			// Variables initialization
			bool isTest = false;
			
			careReceiverId.setSsin(ssin);
			careReceiverId.setMutuality(mutuality);
			careReceiverId.setRegNrWithMut(registNumber);
			
			request.setCareReceiver(careReceiverId);
			request.setDate(requestDate);
			request.setRequestType(requestType);
			
			insurabilityRequest = requestObjectBuilder.buildInsurabilityForPharmacistRequest(isTest, references, request);
			
			// Construction asserts
			ReflectionAssert.assertReflectionEquals(request, insurabilityRequest.getInsurabilityRequest(), ReflectionComparatorMode.LENIENT_ORDER);
			Assert.AreEqual(references.getRecordCommonInputId(), insurabilityRequest.getRecordCommonInput().getUserReference());
			Assert.AreEqual(isTest, insurabilityRequest.getCommonInput().getRequest().isIsTest());
			
			// Session & service
			InsurabilityService insurabilityService = InsurabilitySessionServiceFactory.getInsurabilityService();
			try {
				GetInsurabilityForPharmacistResponse insurabilityForPharmacist = insurabilityService.getInsurabilityForPharmacist(insurabilityRequest);
				Assert.AreEqual("200", insurabilityForPharmacist.getStatus().getCode());
				
			} catch (SoaErrorException e) {
				GetInsurabilityForPharmacistResponse response = (GetInsurabilityForPharmacistResponse) e.getResponseType();
				ReturnCodeType returnCode = response.getReturnInfo().getReturnCode();
				Console.WriteLine("Error Status received [" + e.getErrorCode() + "]: Major[" + returnCode.getMajor() + "] Minor [" + returnCode.getMinor() + "] Detail [" + returnCode.getDetail() + "]");
				throw e;
			}
		}
	}
}
