/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink;

import org.junit.Assert;
import org.junit.Test;
import org.unitils.reflectionassert.ReflectionAssert;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.requests.PutTherapeuticLinkRequest;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.ehealth.businessconnector.therlink.util.ConfigReader;


/**
 * integration tests ( needs eid card ) for {@link DefaultImplementationForgeneralPractitioner}.
 * 
 * @author EHP
 * 
 */
public class DefaultImplPersPhysicionIntegrationTest extends AbstractDefaultImplementationPersphysician {


    /**
     * @throws Exception
     */
    @Test
    public void testCreatePutTherapeuticLinkRequestGPDefaultValues() throws Exception {
        Patient patient = new Patient();
        patient.setSisCardNumber("someSisCardNumber");
        patient.setInss("77013014990");
        PutTherapeuticLinkRequest request = DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithSisReading(patient);
        Assert.assertNotNull(request);
        HcParty hcp = ConfigReader.getCareProvider();
        ReflectionAssert.assertLenientEquals(patient, request.getLink().getPatient());
        ReflectionAssert.assertLenientEquals(hcp, request.getLink().getHcParty());
        Assert.assertEquals(GPCONSULTATION, request.getLink().getType());
    }

    @Test(expected = TherLinkBusinessConnectorException.class)
    public void testPatientWithoutSisCardNumberForReadingWithSisNoSis() throws Exception {
        Patient patient = new Patient();
        patient.setInss(props.getProperty(PROP_TEST_PATIENT_NISS));
        DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithSisReading(patient);
    }

    @Test(expected = TherLinkBusinessConnectorException.class)
    public void testPatientWithoutSsinForReadingWithSisNoNiss() throws Exception {
        Patient patient = new Patient();
        patient.setSisCardNumber("sidCardNumber");
        DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithSisReading(patient);
    }

    @Test(expected = TherLinkBusinessConnectorException.class)
    public void testPatientWithoutSsinForReadingWithIsiNoNiss() throws Exception {
        Patient patient = new Patient();
        patient.setIsiCardNumber("sidCardNumber");
        DefaultImplementationForgeneralPractitioner.createDefaultTherapeuticLinkWithIsiReading(patient);
    }

}
