/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.tarification.helper;

import java.io.InputStream;

import org.junit.Test;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse;


/**
 * tests the ResponseHelper, a class that validates the xml of a response.
 * 
 * @author EH058
 * 
 * @since
 * 
 */
public class ResponseHelperTest {

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.tarification.helper.ResponseHelper#validateResponse(be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse)}
     * .
     */
    @Test
    public void testValidateResponse() throws Exception {
        InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/responseHelperTestSuccess.xml");
        RetrieveTransactionResponse response = ResponseHelper.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream));
        ResponseHelper.validateResponse(response);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.tarification.helper.ResponseHelper#toObject(byte[])}.
     */
    @Test
    public void testToObject() throws Exception {
        InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/responseHelperTestSuccess.xml");
        ResponseHelper.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream));
    }

    // /**
    // * Test method for {@link be.ehealth.businessconnector.tarification.helper.ResponseHelper#getError(byte[])}.
    // */
    // @Test
    // public void testGetErrorByteArrayWithErrors() throws Exception {
    // InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/responseHelperTestFail.xml");
    // List<ErrorMyCarenetType> errors =
    // ResponseHelper.getError(ResponseHelper.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream)));
    // Assert.assertNotNull(errors);
    // }
    //
    // /**
    // * Test method for {@link
    // be.ehealth.businessconnector.tarification.helper.ResponseHelper#getError(be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse)}.
    // */
    // @Test
    // public void testGetErrorRetrieveTransactionResponseNoError() throws Exception {
    // InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream("/examples/responseHelperTestSuccess.xml");
    // RetrieveTransactionResponse response = ResponseHelper.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream));
    // List<ErrorMyCarenetType> errors = ResponseHelper.getError(response);
    // Assert.assertEquals(0, errors.size());
    // }

}
