/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.insurability.service.impl;

import be.ehealth.businessconnector.insurability.exception.InsurabilityBusinessConnectorException;
import be.ehealth.businessconnector.insurability.service.InsurabilityService;
import be.ehealth.businessconnector.insurability.service.ServiceFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.EhealthReplyValidator;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.insurability.protocol.v1.GetInsurabilityForPharmacistRequest;
import be.fgov.ehealth.insurability.protocol.v1.GetInsurabilityForPharmacistResponse;
import javax.xml.soap.SOAPException;

public class InsurabilityServiceImpl
implements InsurabilityService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private SessionValidator sessionValidator;
    private EhealthReplyValidator ehealthReplyValidator;

    public InsurabilityServiceImpl(SessionValidator sessVal, EhealthReplyValidator ehRepVal) throws TechnicalConnectorException {
        this.sessionValidator = sessVal;
        this.ehealthReplyValidator = ehRepVal;
    }

    public InsurabilityServiceImpl() {
    }

    @Override
    public GetInsurabilityForPharmacistResponse getInsurabilityForPharmacist(SAMLToken token, GetInsurabilityForPharmacistRequest request) throws InsurabilityBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            this.sessionValidator.validateToken(token);
            GenericRequest service = ServiceFactory.getService(token);
            service.setPayload((Object)request);
            service.setSoapAction("urn:be:fgov:ehealth:insurability:protocol:v1:GetInsurabilityForPharmacist");
            GetInsurabilityForPharmacistResponse response = (GetInsurabilityForPharmacistResponse)be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service).asObject(GetInsurabilityForPharmacistResponse.class);
            this.ehealthReplyValidator.validateReplyStatus((ResponseType)response);
            return response;
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityForPharmacistRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityForPharmacistResponse.class});
    }
}

