﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using org.joda.time.format;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.fgov.ehealth.standards.kmehr.dt.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.business.common.domain;
using be.ehealth.businessconnector.mycarenet.attest.builders;
using be.ehealth.businessconnector.mycarenet.attest.domain;
using be.ehealth.businessconnector.mycarenet.attest.session;
using be.ehealth.technicalconnector.adapter;
using be.fgov.ehealth.mycarenet.attest.protocol.v1;
using be.ehealth.business.mycarenetdomaincommons.domain;



namespace be.ehealth.businessconnector.tarification.session
{


/**
 * eAttest Integration Test. The scenarios numbering matches one specified by mycarenet.
 *
 * @author EHP
 */
[TestFixture]
public class AttestIntegrationTest {

    private static HashMap nissProvider = new HashMap();

    private static HashMap nissMatchScenario = new HashMap();

    static object[] testCase =
{
    new Object[]{"100", "73052005540", "01", "11772830004"},
          new Object[]{"600", "70021546287", "01", "10830643004"},
          new Object[]{"100", "73052005540", "02", "11772830004"},
          new Object[]{"600", "70021546287", "02", "10830643004"},
          new Object[]{"100", "73052005540", "03", "11772830004"},
          new Object[]{"600", "70021546287", "03", "10830643004"},
          new Object[]{"100", "73052005540", "04", "11772830004"},
          new Object[]{"600", "70021546287", "04", "10830643004"},
          new Object[]{"100", "84101727579", "05", "11772830004"},
          new Object[]{"600", "03051303986", "05", "10830643004"},
          new Object[]{"500", "13070421120", "06", "14455473004"},
          new Object[]{"600", "70021546287", "06", "10830643004"},
          new Object[]{"100", "73052005540", "07", "11772830004"},
          new Object[]{"600", "70021546287", "07", "10830643004"},
          new Object[]{"100", "29041433972", "08", "11772830004"},
          new Object[]{"300", "63042408660", "08", "19330813004"},
          new Object[]{"600", "10090820056", "08", "10830643004"},
          new Object[]{"100", "73052005540", "09", "11772830004"},
          new Object[]{"600", "70021546287", "09", "10830643004"},
          new Object[]{"600", "69021902691", "10", "10830643004"},
          new Object[]{"300", "17031506487", "11", "19330813004"},
          new Object[]{"600", "70021546287", "11", "10830643004"},
          new Object[]{"300", "63042408660", "12", "19330813004"},
          new Object[]{"600", "10090820056", "12", "10830643004"},
          new Object[]{"300", "87052226861", "13", "19330813004"},
          new Object[]{"600", "69021902691", "13", "10830643004"},
          new Object[]{"300", "87120924439", "14", "19330813004"},
          new Object[]{"600", "60042560332", "14", "10830643004"},
          new Object[]{"300", "17031506487", "15", "19330813004"},
          new Object[]{"600", "70021546287", "15", "10830643004"},
          new Object[]{"300", "17031506487", "16", "19330813004"},
          new Object[]{"600", "70021546287", "16", "10830643004"},
          new Object[]{"300", "17031506487", "17", "19330813004"},
          new Object[]{"600", "70021546287", "17", "10830643004"},
          new Object[]{"300", "37061311820", "18", "19330813004"},
          new Object[]{"600", "53081411750", "18", "10830643004"}
};

    [SetUp]
    public static  void setupsession() {
        SessionInitializer.init(".\\be.ehealth.businessconnector.attest.test.properties", SupportedLanguages.NET.getAbbreviation());
    }

    [TearDown]
    public static void teardownSession()  {
        Session.getInstance().unloadSession();
    }


    [Test, TestCaseSource("testCase")]
    public void sendAttestationTest(String oa, String niss, String scenarioId, String dmgManager) {
        //given
        Ssin nissValue = new Ssin(niss);
        org.joda.time.DateTime dateReference = new org.joda.time.DateTime();
        RequestObjectBuilder builder = RequestObjectBuilderFactory.getRequestObjectBuilder();
        InputReference inputReference = new InputReference();
        Kmehrmessage kmehrRequest = buildKmehrmessage(niss, scenarioId, dmgManager);
        SendAttestationRequest sendAttestationRequest = builder.buildSendAttestationRequest(true, inputReference, nissValue, dateReference, kmehrRequest);
        AttestService service = AttestSessionServiceFactory.getAttestService();

        //when
        SendAttestationResponse response = service.sendAttestation(sendAttestationRequest);
        ConnectorXmlUtils.dump(response);
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        AttestBuilderResponse builderResponse = responseBuilder.handleSendResponseType(response, sendAttestationRequest);

        //then
        Assert.True(builderResponse.getSendTransactionResponse().getResponse().getId().getValue().matches("^"+oa+".(\\d{14}$)"), "Response id should have pattern oa number + '.' + 14 digits (we don't check that it is a date/time)");
        Assert.AreEqual(0, builderResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
        String expectedResponse = buildExpectedResponse(builderResponse, inputReference.getInputReference(), scenarioId, oa);
        XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(builderResponse.getSendTransactionResponse()));
    }

    private String buildExpectedResponse(AttestBuilderResponse builderResponse, String inputReference, String scenarioId, String oa) {
        Map velocityContext = new HashMap();
        velocityContext.put("today", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
        velocityContext.put("responseId", builderResponse.getSendTransactionResponse().getResponse().getId().getValue());
        velocityContext.put("requestId", "18334780004" + "." + inputReference);
        velocityContext.put("responseTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getTime()));
        velocityContext.put("requestTime",  new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getRequest().getTime()));

        if (builderResponse.getSendTransactionResponse().getKmehrmessage() != null) {
            velocityContext.put("headerTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getKmehrmessage().getHeader().getTime()));
            java.util.List folders = builderResponse.getSendTransactionResponse().getKmehrmessage().getFolders();
            for (int i=0; i<folders.size(); i++) {
                java.util.List transactions = ((FolderType) folders.get(i)).getTransactions();
                for (int j=0; j<transactions.size(); j++) {
                	TransactionType transaction = (TransactionType) transactions.get(j);
                    velocityContext.put("transactionTime" + ((IDKMEHR) transaction.getIds().get(0)).getValue(), new XmlTimeAdapter().marshal(transaction.getTime()));
                    if ("invoicingnumber".Equals(((CDITEM)((ItemType) transaction.getItem().get(0)).getCds().get(0)).getValue())) {
                    	velocityContext.put("invoicingNumber", ((TextType)((ContentType)((ItemType)transaction.getItem().get(0)).getContents().get(0)).getTexts().get(0)).getValue());
                    }
                }
            }
        }
        return TemplateEngineUtils.generate(velocityContext,".\\scenarios.\\expected.\\responseDetail-" + oa + "-" + scenarioId + ".xml");
    }


    private Kmehrmessage buildKmehrmessage(String niss, String scenarioId, String dmgManager){
        Map velocityContext = new HashMap();
        velocityContext.put("today", DateUtils.printDateTime(new org.joda.time.DateTime()));
        velocityContext.put("ssin", niss);
        velocityContext.put("DMGMANAGER_INA", dmgManager);
        String kmerh = TemplateEngineUtils.generate(velocityContext, ".\\scenarios.\\requests.\\TClearFile-AAA-" + scenarioId + ".xml");

        MarshallerHelper kmehrRequestMarshaller = new MarshallerHelper(typeof(Kmehrmessage), typeof(Kmehrmessage));
        Kmehrmessage request = (Kmehrmessage) kmehrRequestMarshaller.toObject(kmerh);
        return request;
    }
}

}
