/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.addressbook.integration;

import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.businessconnector.addressbook.session.AddressbookSessionService;
import be.ehealth.businessconnector.addressbook.session.AddressbookSessionServiceFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsResponse;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

/**
 * Integration test for addressbook with session
 * 
 * @author EHP
 *
 */
public class AddressbookSessionIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    @Test
    public void getOrganizationContactInfoTest() throws ConnectorException {
        GetOrganizationContactInfoRequest request = AddressbookTestUtils.createGetOrganizationContactInfoRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        GetOrganizationContactInfoResponse response = service.getOrganizationContactInfo(request);
        AddressbookTestUtils.verifyResponseGetOrganizationContactInfo(response);
    }

    @Test
    public void getProfessionalContactInfoTest() throws ConnectorException {
        GetProfessionalContactInfoRequest request = AddressbookTestUtils.createGetProfessionalContactInfo();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        GetProfessionalContactInfoResponse response = service.getProfessionalContactInfo(request);
        AddressbookTestUtils.verifyResponseGetProfessionalContactInfo(response);
    }

    @Test
    public void searchOrganizationsTest() throws ConnectorException {
        SearchOrganizationsRequest request = AddressbookTestUtils.createSearchOrganizationsRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        SearchOrganizationsResponse response = service.searchOrganizations(request);
        AddressbookTestUtils.verifySearchOrganizationsResponse(response);
    }

    @Test
    public void searchProfessionalsTest() throws ConnectorException {
        SearchProfessionalsRequest request = AddressbookTestUtils.createSearchProfessionalsRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        SearchProfessionalsResponse response = service.searchProfessionals(request);
        AddressbookTestUtils.verifySearchProfessionalsResponse(response);
    }
}
