/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.kmehrcommons.builders;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;


/**
 * Test for the non yet tested method of HcPartyBuilder
 * 
 * @author EHP
 * 
 */
public class HcPartyBuilderTest {

    /**
     * Test method for {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#id(java.lang.String, java.lang.String)}.
     */
    @Test
    public void testMethodIdAndCd1() throws TechnicalConnectorException {
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x").cd("1.1", "x", CDHCPARTYschemes.CD_HCPARTY);
        HcpartyType builded = hcpBuilder.build();

        Assert.assertEquals("1.0", builded.getIds().get(0).getSV());
        Assert.assertEquals("x", builded.getIds().get(0).getValue());
        Assert.assertEquals("1.1", builded.getCds().get(0).getSV());
        Assert.assertEquals("x", builded.getCds().get(0).getValue());
    }

    /**
     * Test method for
     * {@link be.ehealth.business.kmehrcommons.builders.HcPartyBuilder#id(java.lang.String, be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes)}
     * .
     */
    @Test
    public void testMethodIDAndCd2() throws TechnicalConnectorException {
        HcPartyBuilder hcpBuilder = new HcPartyBuilder();
        hcpBuilder.id("1.0", "x", IDHCPARTYschemes.INSS).cd("1.1", "x", CDHCPARTYschemes.LOCAL, "1.2");
        HcpartyType builded = hcpBuilder.build();

        Assert.assertEquals("x", builded.getIds().get(0).getValue());
        Assert.assertEquals(IDHCPARTYschemes.INSS, builded.getIds().get(0).getS());
        Assert.assertEquals("1.1", builded.getCds().get(0).getSV());
        Assert.assertEquals("x", builded.getCds().get(0).getValue());
        Assert.assertEquals(CDHCPARTYschemes.LOCAL, builded.getCds().get(0).getS());
        Assert.assertEquals("1.2", builded.getCds().get(0).getSL());
    }

}
