/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.mycarenet.attest.builders.impl;

import be.cin.encrypted.EncryptedKnownContent;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.businessconnector.mycarenet.attest.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.mycarenet.attest.domain.AttestBuilderResponse;
import be.ehealth.businessconnector.mycarenet.attest.mappers.BlobMapper;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.messageservices.core.v1.SendTransactionResponse;
import be.fgov.ehealth.mycarenet.attest.protocol.v1.SendAttestationRequest;
import be.fgov.ehealth.mycarenet.attest.protocol.v1.SendAttestationResponse;
import be.fgov.ehealth.mycarenet.commons.core.v3.BlobType;
import be.fgov.ehealth.mycarenet.commons.protocol.v3.SendResponseType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;

public class ResponseObjectBuilderImpl
implements ResponseObjectBuilder,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    @Override
    public final AttestBuilderResponse handleSendResponseType(SendResponseType sendResponse, SendAttestationRequest sendRequest) throws TechnicalConnectorException, UnsupportedEncodingException {
        BlobType blobType = sendResponse.getReturn().getDetail();
        Blob blob = BlobMapper.mapBlobfromBlobType(blobType);
        return this.createAttestBuilderResponse(blob);
    }

    private AttestBuilderResponse createAttestBuilderResponse(Blob blob) throws TechnicalConnectorException {
        byte[] unsealedData = SessionUtil.getHolderOfKeyCrypto().unseal(Crypto.SigningPolicySelector.WITHOUT_NON_REPUDIATION, blob.getContent()).getContentAsByte();
        EncryptedKnownContent encryptedKnownContent = (EncryptedKnownContent)new MarshallerHelper(EncryptedKnownContent.class, EncryptedKnownContent.class).toObject(unsealedData);
        byte[] xades = encryptedKnownContent.getXades();
        SignatureBuilder builder = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES);
        Map options = Collections.emptyMap();
        SignatureVerificationResult signatureVerificationResult = builder.verify(unsealedData, xades, options);
        SendTransactionResponse sendTransactionResponse = (SendTransactionResponse)new MarshallerHelper(SendTransactionResponse.class, SendTransactionResponse.class).toObject(encryptedKnownContent.getBusinessContent().getValue());
        return new AttestBuilderResponse(sendTransactionResponse, signatureVerificationResult);
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{BlobType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendAttestationResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendResponseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrmessage.class});
    }
}

