/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.ra.utils;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.etkra.protocol.v1.StartEtkRegistrationResponse;


/**
 * @author EHP
 */
public class CertificateUtilsTest {

    @Test
    public void obtainSerialNumber() throws Exception {
        byte[] challenge = new MarshallerHelper<StartEtkRegistrationResponse, StartEtkRegistrationResponse>(StartEtkRegistrationResponse.class, StartEtkRegistrationResponse.class).toObject(ConnectorIOUtils.getResourceAsStream("/ra-samples/response/StartEtkRegistrationResponse.xml")).getChallenge();
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(ConnectorIOUtils.getResourceAsStream("/ra-samples/challenge.p12"), "15".toCharArray());
        Key key = store.getKey("0", "15".toCharArray());
        BigInteger serial = CertificateUtils.obtainSerialNumber((PrivateKey) key, challenge);
        Assert.assertEquals("311987391983331999458504645212116240958", serial.toString(10));
    }

}
